/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.CompressedSerializedValue;
import org.apache.flink.util.Preconditions;

public class InputGateDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = -7143441863165366704L;
    private final IntermediateDataSetID consumedResultId;
    private final ResultPartitionType consumedPartitionType;
    private final IndexRange consumedSubpartitionIndexRange;
    private transient ShuffleDescriptor[] inputChannels;
    private final List<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]>> serializedInputChannels;
    private final int numberOfInputChannels;

    @VisibleForTesting
    public InputGateDeploymentDescriptor(IntermediateDataSetID consumedResultId, ResultPartitionType consumedPartitionType, @Nonnegative int consumedSubpartitionIndex, TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[] inputChannels) throws IOException {
        this(consumedResultId, consumedPartitionType, new IndexRange(consumedSubpartitionIndex, consumedSubpartitionIndex), inputChannels.length, Collections.singletonList(new TaskDeploymentDescriptor.NonOffloaded(CompressedSerializedValue.fromObject((Object)inputChannels))));
    }

    public InputGateDeploymentDescriptor(IntermediateDataSetID consumedResultId, ResultPartitionType consumedPartitionType, IndexRange consumedSubpartitionIndexRange, int numberOfInputChannels, List<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]>> serializedInputChannels) {
        this.consumedResultId = (IntermediateDataSetID)Preconditions.checkNotNull((Object)consumedResultId);
        this.consumedPartitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)consumedPartitionType)));
        this.consumedSubpartitionIndexRange = (IndexRange)Preconditions.checkNotNull((Object)consumedSubpartitionIndexRange);
        this.serializedInputChannels = (List)Preconditions.checkNotNull(serializedInputChannels);
        this.numberOfInputChannels = numberOfInputChannels;
    }

    public IntermediateDataSetID getConsumedResultId() {
        return this.consumedResultId;
    }

    public ResultPartitionType getConsumedPartitionType() {
        return this.consumedPartitionType;
    }

    @Nonnegative
    public int getConsumedSubpartitionIndex() {
        Preconditions.checkState((this.consumedSubpartitionIndexRange.getStartIndex() == this.consumedSubpartitionIndexRange.getEndIndex() ? 1 : 0) != 0);
        return this.consumedSubpartitionIndexRange.getStartIndex();
    }

    public IndexRange getConsumedSubpartitionIndexRange() {
        return this.consumedSubpartitionIndexRange;
    }

    public void loadBigData(@Nullable PermanentBlobService blobService, JobID jobId) throws IOException {
        for (int i = 0; i < this.serializedInputChannels.size(); ++i) {
            TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]> shuffleDescriptors = this.serializedInputChannels.get(i);
            if (!(shuffleDescriptors instanceof TaskDeploymentDescriptor.Offloaded)) continue;
            PermanentBlobKey blobKey = ((TaskDeploymentDescriptor.Offloaded)shuffleDescriptors).serializedValueKey;
            Preconditions.checkNotNull((Object)blobService);
            CompressedSerializedValue serializedValue = CompressedSerializedValue.fromBytes((byte[])blobService.readFile(jobId, blobKey));
            this.serializedInputChannels.set(i, new TaskDeploymentDescriptor.NonOffloaded(serializedValue));
        }
    }

    public ShuffleDescriptor[] getShuffleDescriptors() {
        try {
            if (this.inputChannels == null) {
                this.inputChannels = new ShuffleDescriptor[this.numberOfInputChannels];
                for (TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]> serializedShuffleDescriptors : this.serializedInputChannels) {
                    if (serializedShuffleDescriptors instanceof TaskDeploymentDescriptor.NonOffloaded) {
                        TaskDeploymentDescriptor.NonOffloaded nonOffloadedSerializedValue = (TaskDeploymentDescriptor.NonOffloaded)serializedShuffleDescriptors;
                        TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[] shuffleDescriptorAndIndices = (TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[])nonOffloadedSerializedValue.serializedValue.deserializeValue(this.getClass().getClassLoader());
                        this.putOrReplaceShuffleDescriptors(shuffleDescriptorAndIndices);
                        continue;
                    }
                    throw new IllegalStateException("Trying to work with offloaded serialized shuffle descriptors.");
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Could not deserialize shuffle descriptors.", e);
        }
        return this.inputChannels;
    }

    private void putOrReplaceShuffleDescriptors(TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[] shuffleDescriptorAndIndices) {
        for (TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex shuffleDescriptorAndIndex : shuffleDescriptorAndIndices) {
            ShuffleDescriptor inputChannelDescriptor = this.inputChannels[shuffleDescriptorAndIndex.getIndex()];
            if (inputChannelDescriptor != null) {
                Preconditions.checkState((boolean)inputChannelDescriptor.isUnknown(), (Object)"Only unknown shuffle descriptor can be replaced.");
            }
            this.inputChannels[shuffleDescriptorAndIndex.getIndex()] = shuffleDescriptorAndIndex.getShuffleDescriptor();
        }
    }

    public String toString() {
        return String.format("InputGateDeploymentDescriptor [result id: %s, consumed subpartition index range: %s, input channels: %s]", this.consumedResultId.toString(), this.consumedSubpartitionIndexRange, Arrays.toString(this.getShuffleDescriptors()));
    }
}

