/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializerImpl;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestDispatcherImpl;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutor;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutorImpl;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.util.Preconditions;

public class ChannelStateWriteRequestExecutorFactory {
    private final JobID jobID;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private ChannelStateWriteRequestExecutor executor;

    public ChannelStateWriteRequestExecutorFactory(JobID jobID) {
        this.jobID = jobID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelStateWriteRequestExecutor getOrCreateExecutor(JobVertexID jobVertexID, int subtaskIndex, CheckpointStorage checkpointStorage, int maxSubtasksPerChannelStateFile) {
        Object object = this.lock;
        synchronized (object) {
            if (this.executor == null) {
                this.executor = new ChannelStateWriteRequestExecutorImpl(new ChannelStateWriteRequestDispatcherImpl(checkpointStorage, this.jobID, new ChannelStateSerializerImpl()), maxSubtasksPerChannelStateFile, executor -> {
                    Object object = this.lock;
                    synchronized (object) {
                        Preconditions.checkState((this.executor == executor ? 1 : 0) != 0);
                        this.executor = null;
                    }
                });
                this.executor.start();
            }
            ChannelStateWriteRequestExecutor currentExecutor = this.executor;
            currentExecutor.registerSubtask(jobVertexID, subtaskIndex);
            return currentExecutor;
        }
    }
}

