/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.curator.test.TestingServer;
import org.apache.flink.runtime.testutils.ZooKeeperTestUtils;
import org.apache.flink.util.Preconditions;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperResource
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperResource.class);
    @Nullable
    private TestingServer zooKeeperServer;

    public String getConnectString() {
        this.verifyIsRunning();
        return this.zooKeeperServer.getConnectString();
    }

    private void verifyIsRunning() {
        Preconditions.checkState((this.zooKeeperServer != null ? 1 : 0) != 0);
    }

    protected void before() throws Throwable {
        this.terminateZooKeeperServer();
        this.zooKeeperServer = ZooKeeperTestUtils.createAndStartZookeeperTestingServer();
    }

    private void terminateZooKeeperServer() throws IOException {
        if (this.zooKeeperServer != null) {
            this.zooKeeperServer.close();
            this.zooKeeperServer = null;
        }
    }

    protected void after() {
        try {
            this.terminateZooKeeperServer();
        }
        catch (IOException e) {
            LOG.warn("Could not properly terminate the {}.", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)e);
        }
    }

    public void restart() throws Exception {
        Preconditions.checkNotNull((Object)this.zooKeeperServer);
        this.zooKeeperServer.restart();
    }

    public void stop() throws IOException {
        Preconditions.checkNotNull((Object)this.zooKeeperServer);
        this.zooKeeperServer.stop();
    }
}

