/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.highavailability.JobResultEntry;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingConsumer;

public class TestingJobResultStore
implements JobResultStore {
    public static final JobResult DUMMY_JOB_RESULT = TestingJobResultStore.createSuccessfulJobResult(new JobID());
    private final ThrowingConsumer<JobResultEntry, ? extends IOException> createDirtyResultConsumer;
    private final ThrowingConsumer<JobID, ? extends IOException> markResultAsCleanConsumer;
    private final FunctionWithException<JobID, Boolean, ? extends IOException> hasJobResultEntryFunction;
    private final FunctionWithException<JobID, Boolean, ? extends IOException> hasDirtyJobResultEntryFunction;
    private final FunctionWithException<JobID, Boolean, ? extends IOException> hasCleanJobResultEntryFunction;
    private final SupplierWithException<Set<JobResult>, ? extends IOException> getDirtyResultsSupplier;

    public static JobResult createSuccessfulJobResult(JobID jobId) {
        return TestingJobResultStore.createJobResult(jobId, ApplicationStatus.SUCCEEDED);
    }

    public static JobResult createJobResult(JobID jobId, ApplicationStatus applicationStatus) {
        return new JobResult.Builder().jobId(jobId).applicationStatus(applicationStatus).netRuntime(1L).build();
    }

    private TestingJobResultStore(ThrowingConsumer<JobResultEntry, ? extends IOException> createDirtyResultConsumer, ThrowingConsumer<JobID, ? extends IOException> markResultAsCleanConsumer, FunctionWithException<JobID, Boolean, ? extends IOException> hasJobResultEntryFunction, FunctionWithException<JobID, Boolean, ? extends IOException> hasDirtyJobResultEntryFunction, FunctionWithException<JobID, Boolean, ? extends IOException> hasCleanJobResultEntryFunction, SupplierWithException<Set<JobResult>, ? extends IOException> getDirtyResultsSupplier) {
        this.createDirtyResultConsumer = createDirtyResultConsumer;
        this.markResultAsCleanConsumer = markResultAsCleanConsumer;
        this.hasJobResultEntryFunction = hasJobResultEntryFunction;
        this.hasDirtyJobResultEntryFunction = hasDirtyJobResultEntryFunction;
        this.hasCleanJobResultEntryFunction = hasCleanJobResultEntryFunction;
        this.getDirtyResultsSupplier = getDirtyResultsSupplier;
    }

    public void createDirtyResult(JobResultEntry jobResultEntry) throws IOException {
        this.createDirtyResultConsumer.accept((Object)jobResultEntry);
    }

    public void markResultAsClean(JobID jobId) throws IOException {
        this.markResultAsCleanConsumer.accept((Object)jobId);
    }

    public boolean hasJobResultEntry(JobID jobId) throws IOException {
        return (Boolean)this.hasJobResultEntryFunction.apply((Object)jobId);
    }

    public boolean hasDirtyJobResultEntry(JobID jobId) throws IOException {
        return (Boolean)this.hasDirtyJobResultEntryFunction.apply((Object)jobId);
    }

    public boolean hasCleanJobResultEntry(JobID jobId) throws IOException {
        return (Boolean)this.hasCleanJobResultEntryFunction.apply((Object)jobId);
    }

    public Set<JobResult> getDirtyResults() throws IOException {
        return (Set)this.getDirtyResultsSupplier.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ThrowingConsumer<JobResultEntry, ? extends IOException> createDirtyResultConsumer = ignored -> {};
        private ThrowingConsumer<JobID, ? extends IOException> markResultAsCleanConsumer = ignored -> {};
        private FunctionWithException<JobID, Boolean, ? extends IOException> hasJobResultEntryFunction = ignored -> false;
        private FunctionWithException<JobID, Boolean, ? extends IOException> hasDirtyJobResultEntryFunction = ignored -> false;
        private FunctionWithException<JobID, Boolean, ? extends IOException> hasCleanJobResultEntryFunction = ignored -> false;
        private SupplierWithException<Set<JobResult>, ? extends IOException> getDirtyResultsSupplier = Collections::emptySet;

        public Builder withCreateDirtyResultConsumer(ThrowingConsumer<JobResultEntry, ? extends IOException> createDirtyResultConsumer) {
            this.createDirtyResultConsumer = createDirtyResultConsumer;
            return this;
        }

        public Builder withMarkResultAsCleanConsumer(ThrowingConsumer<JobID, ? extends IOException> markResultAsCleanConsumer) {
            this.markResultAsCleanConsumer = markResultAsCleanConsumer;
            return this;
        }

        public Builder withHasJobResultEntryFunction(FunctionWithException<JobID, Boolean, ? extends IOException> hasJobResultEntryFunction) {
            this.hasJobResultEntryFunction = hasJobResultEntryFunction;
            return this;
        }

        public Builder withHasDirtyJobResultEntryFunction(FunctionWithException<JobID, Boolean, ? extends IOException> hasDirtyJobResultEntryFunction) {
            this.hasDirtyJobResultEntryFunction = hasDirtyJobResultEntryFunction;
            return this;
        }

        public Builder withHasCleanJobResultEntryFunction(FunctionWithException<JobID, Boolean, ? extends IOException> hasCleanJobResultEntryFunction) {
            this.hasCleanJobResultEntryFunction = hasCleanJobResultEntryFunction;
            return this;
        }

        public Builder withGetDirtyResultsSupplier(SupplierWithException<Set<JobResult>, ? extends IOException> getDirtyResultsSupplier) {
            this.getDirtyResultsSupplier = getDirtyResultsSupplier;
            return this;
        }

        public TestingJobResultStore build() {
            return new TestingJobResultStore(this.createDirtyResultConsumer, this.markResultAsCleanConsumer, this.hasJobResultEntryFunction, this.hasDirtyJobResultEntryFunction, this.hasCleanJobResultEntryFunction, this.getDirtyResultsSupplier);
        }
    }
}

