/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.function.Supplier;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.TestingClassLoaderLease;
import org.apache.flink.runtime.taskexecutor.JobTable;

public class TestingJobServices
implements JobTable.JobServices {
    private final Supplier<LibraryCacheManager.ClassLoaderHandle> classLoaderHandleSupplier;
    private final Runnable closeRunnable;

    private TestingJobServices(Supplier<LibraryCacheManager.ClassLoaderHandle> classLoaderHandleSupplier, Runnable closeRunnable) {
        this.classLoaderHandleSupplier = classLoaderHandleSupplier;
        this.closeRunnable = closeRunnable;
    }

    public LibraryCacheManager.ClassLoaderHandle getClassLoaderHandle() {
        return this.classLoaderHandleSupplier.get();
    }

    public void close() {
        this.closeRunnable.run();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final TestingClassLoaderLease testingClassLoaderLease = TestingClassLoaderLease.newBuilder().build();
        private Supplier<LibraryCacheManager.ClassLoaderHandle> classLoaderHandleSupplier = () -> this.testingClassLoaderLease;
        private Runnable closeRunnable = () -> {};

        public Builder setClassLoaderHandleSupplier(Supplier<LibraryCacheManager.ClassLoaderHandle> classLoaderHandleSupplier) {
            this.classLoaderHandleSupplier = classLoaderHandleSupplier;
            return this;
        }

        public Builder setCloseRunnable(Runnable closeRunnable) {
            this.closeRunnable = closeRunnable;
            return this;
        }

        public TestingJobServices build() {
            return new TestingJobServices(this.classLoaderHandleSupplier, this.closeRunnable);
        }
    }
}

