/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import java.util.Map;
import org.apache.flink.runtime.security.token.DelegationTokenContainer;
import org.apache.flink.util.InstantiationUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DelegationTokenContainerTest {
    private static final String TOKEN_KEY = "TEST_TOKEN_KEY";
    private static final String TOKEN_VALUE = "TEST_TOKEN_VALUE";

    DelegationTokenContainerTest() {
    }

    @Test
    public void testRoundTrip() throws Exception {
        DelegationTokenContainer container = new DelegationTokenContainer();
        container.addToken(TOKEN_KEY, TOKEN_VALUE.getBytes());
        byte[] containerBytes = InstantiationUtil.serializeObject((Object)container);
        DelegationTokenContainer deserializedContainer = (DelegationTokenContainer)InstantiationUtil.deserializeObject((byte[])containerBytes, (ClassLoader)this.getClass().getClassLoader());
        Map genericTokens = deserializedContainer.getTokens();
        Assertions.assertEquals((int)1, (int)genericTokens.size());
        Assertions.assertArrayEquals((byte[])TOKEN_VALUE.getBytes(), (byte[])((byte[])genericTokens.get(TOKEN_KEY)));
    }

    @Test
    public void getTokenShouldReturnNullWhenNoTokens() {
        DelegationTokenContainer container = new DelegationTokenContainer();
        Assertions.assertNull(container.getTokens().get(TOKEN_KEY));
    }

    @Test
    public void hasTokensShouldReturnFalseWhenNoTokens() {
        DelegationTokenContainer container = new DelegationTokenContainer();
        Assertions.assertFalse((boolean)container.hasTokens());
    }

    @Test
    public void hasTokensShouldReturnTrueWithGenericToken() {
        DelegationTokenContainer container = new DelegationTokenContainer();
        container.addToken(TOKEN_KEY, TOKEN_VALUE.getBytes());
        Assertions.assertTrue((boolean)container.hasTokens());
    }
}

