/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingResultPartition;
import org.apache.flink.util.IterableUtils;

public class TestingSchedulingExecutionVertex
implements SchedulingExecutionVertex {
    private final ExecutionVertexID executionVertexId;
    private final List<ConsumedPartitionGroup> consumedPartitionGroups;
    private final Collection<TestingSchedulingResultPartition> producedPartitions;
    private final Map<IntermediateResultPartitionID, TestingSchedulingResultPartition> resultPartitionsById;
    private ExecutionState executionState;

    public TestingSchedulingExecutionVertex(JobVertexID jobVertexId, int subtaskIndex, ExecutionState executionState) {
        this.executionVertexId = new ExecutionVertexID(jobVertexId, subtaskIndex);
        this.consumedPartitionGroups = new ArrayList<ConsumedPartitionGroup>();
        this.producedPartitions = new ArrayList<TestingSchedulingResultPartition>();
        this.resultPartitionsById = new HashMap<IntermediateResultPartitionID, TestingSchedulingResultPartition>();
        this.executionState = executionState;
    }

    public ExecutionVertexID getId() {
        return this.executionVertexId;
    }

    public ExecutionState getState() {
        return this.executionState;
    }

    public void setState(ExecutionState state) {
        this.executionState = state;
    }

    public Iterable<TestingSchedulingResultPartition> getConsumedResults() {
        return IterableUtils.flatMap(this.consumedPartitionGroups, this.resultPartitionsById::get);
    }

    public Iterable<TestingSchedulingResultPartition> getProducedResults() {
        return this.producedPartitions;
    }

    public List<ConsumedPartitionGroup> getConsumedPartitionGroups() {
        return this.consumedPartitionGroups;
    }

    void addConsumedPartitionGroup(ConsumedPartitionGroup consumedPartitionGroup, Map<IntermediateResultPartitionID, TestingSchedulingResultPartition> consumedResultPartitionById) {
        this.consumedPartitionGroups.add(consumedPartitionGroup);
        this.resultPartitionsById.putAll(consumedResultPartitionById);
    }

    void addProducedPartition(TestingSchedulingResultPartition partition) {
        this.producedPartitions.add(partition);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static TestingSchedulingExecutionVertex withExecutionVertexID(JobVertexID jobVertexId, int subtaskIndex) {
        return TestingSchedulingExecutionVertex.newBuilder().withExecutionVertexID(jobVertexId, subtaskIndex).build();
    }

    public static class Builder {
        private JobVertexID jobVertexId = new JobVertexID();
        private int subtaskIndex = 0;
        private ExecutionState executionState = ExecutionState.CREATED;

        Builder withExecutionVertexID(JobVertexID jobVertexId, int subtaskIndex) {
            this.jobVertexId = jobVertexId;
            this.subtaskIndex = subtaskIndex;
            return this;
        }

        public Builder withExecutionState(ExecutionState executionState) {
            this.executionState = executionState;
            return this;
        }

        public TestingSchedulingExecutionVertex build() {
            return new TestingSchedulingExecutionVertex(this.jobVertexId, this.subtaskIndex, this.executionState);
        }
    }
}

