/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.benchmark.scheduling;

import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.scheduler.SchedulerOperations;
import org.apache.flink.runtime.scheduler.benchmark.JobConfiguration;
import org.apache.flink.runtime.scheduler.benchmark.scheduling.SchedulingBenchmarkBase;
import org.apache.flink.runtime.scheduler.strategy.PipelinedRegionSchedulingStrategy;

public class SchedulingDownstreamTasksInBatchJobBenchmark
extends SchedulingBenchmarkBase {
    private PipelinedRegionSchedulingStrategy schedulingStrategy;
    private int parallelism;

    @Override
    public void setup(JobConfiguration jobConfiguration) throws Exception {
        super.setup(jobConfiguration);
        this.schedulingStrategy = new PipelinedRegionSchedulingStrategy((SchedulerOperations)this.schedulerOperations, this.schedulingTopology);
        this.parallelism = jobConfiguration.getParallelism();
    }

    public void schedulingDownstreamTasks() {
        for (int i = 0; i < this.parallelism - 1; ++i) {
            ExecutionVertex taskVertex = this.executionGraph.getJobVertex(((JobVertex)this.jobVertices.get(0)).getID()).getTaskVertices()[i];
            taskVertex.finishPartitionsIfNeeded();
            this.schedulingStrategy.onExecutionStateChange(taskVertex.getID(), ExecutionState.FINISHED);
        }
        ExecutionVertex lastVertex = this.executionGraph.getJobVertex(((JobVertex)this.jobVertices.get(0)).getID()).getTaskVertices()[this.parallelism - 1];
        lastVertex.finishPartitionsIfNeeded();
        this.schedulingStrategy.onExecutionStateChange(lastVertex.getID(), ExecutionState.FINISHED);
    }
}

