/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.DefaultPreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.TestingInputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultPreferredLocationsRetrieverTest {
    DefaultPreferredLocationsRetrieverTest() {
    }

    @Test
    void testStateLocationsWillBeReturnedIfExist() {
        LocalTaskManagerLocation stateLocation = new LocalTaskManagerLocation();
        TestingInputsLocationsRetriever.Builder locationRetrieverBuilder = new TestingInputsLocationsRetriever.Builder();
        ExecutionVertexID consumerId = new ExecutionVertexID(new JobVertexID(), 0);
        ExecutionVertexID producerId = new ExecutionVertexID(new JobVertexID(), 0);
        locationRetrieverBuilder.connectConsumerToProducer(consumerId, producerId);
        TestingInputsLocationsRetriever inputsLocationsRetriever = locationRetrieverBuilder.build();
        inputsLocationsRetriever.markScheduled(producerId);
        DefaultPreferredLocationsRetriever locationsRetriever = new DefaultPreferredLocationsRetriever(id -> Optional.of(stateLocation), (InputsLocationsRetriever)inputsLocationsRetriever);
        CompletableFuture preferredLocations = locationsRetriever.getPreferredLocations(consumerId, Collections.emptySet());
        Assertions.assertThat((Collection)preferredLocations.getNow(null)).containsExactly((Object[])new TaskManagerLocation[]{stateLocation});
    }

    @Test
    void testInputLocations() {
        List<TaskManagerLocation> producerLocations = Collections.singletonList(new LocalTaskManagerLocation());
        this.testInputLocationsInternal(1, 8, producerLocations, producerLocations, Collections.emptySet());
    }

    @Test
    void testInputLocationsIgnoresEdgeOfTooManyProducers() {
        this.testNoPreferredInputLocationsInternal(9, 1);
    }

    @Test
    void testInputLocationsIgnoresEdgeOfTooManyConsumers() {
        this.testNoPreferredInputLocationsInternal(1, 9);
        this.testNoPreferredInputLocationsInternal(2, 9);
    }

    @Test
    void testInputLocationsChoosesInputOfFewerLocations() {
        int i;
        TestingInputsLocationsRetriever.Builder locationRetrieverBuilder = new TestingInputsLocationsRetriever.Builder();
        ExecutionVertexID consumerId = new ExecutionVertexID(new JobVertexID(), 0);
        int parallelism1 = 3;
        JobVertexID jobVertexId1 = new JobVertexID();
        ArrayList<ExecutionVertexID> producers1 = new ArrayList<ExecutionVertexID>(parallelism1);
        for (int i2 = 0; i2 < parallelism1; ++i2) {
            ExecutionVertexID producerId = new ExecutionVertexID(jobVertexId1, i2);
            producers1.add(producerId);
        }
        locationRetrieverBuilder.connectConsumerToProducers(consumerId, producers1);
        JobVertexID jobVertexId2 = new JobVertexID();
        int parallelism2 = 5;
        ArrayList<ExecutionVertexID> producers2 = new ArrayList<ExecutionVertexID>(parallelism2);
        for (int i3 = 0; i3 < parallelism2; ++i3) {
            ExecutionVertexID producerId = new ExecutionVertexID(jobVertexId2, i3);
            producers2.add(producerId);
        }
        locationRetrieverBuilder.connectConsumerToProducers(consumerId, producers2);
        TestingInputsLocationsRetriever inputsLocationsRetriever = locationRetrieverBuilder.build();
        ArrayList<Object> expectedLocations = new ArrayList<Object>(parallelism1);
        for (i = 0; i < parallelism1; ++i) {
            inputsLocationsRetriever.assignTaskManagerLocation((ExecutionVertexID)producers1.get(i));
            expectedLocations.add(inputsLocationsRetriever.getTaskManagerLocation((ExecutionVertexID)producers1.get(i)).get().getNow(null));
        }
        for (i = 0; i < parallelism2; ++i) {
            inputsLocationsRetriever.assignTaskManagerLocation((ExecutionVertexID)producers2.get(i));
        }
        DefaultPreferredLocationsRetriever locationsRetriever = new DefaultPreferredLocationsRetriever(id -> Optional.empty(), (InputsLocationsRetriever)inputsLocationsRetriever);
        CompletableFuture preferredLocations = locationsRetriever.getPreferredLocations(consumerId, Collections.emptySet());
        Assertions.assertThat((Collection)preferredLocations.getNow(null)).containsExactlyInAnyOrderElementsOf(expectedLocations);
    }

    @Test
    void testInputLocationsIgnoresExcludedProducers() {
        List<TaskManagerLocation> producerLocations = Arrays.asList(new TaskManagerLocation[]{new LocalTaskManagerLocation(), new LocalTaskManagerLocation()});
        Set<Integer> producersToIgnore = Collections.singleton(0);
        this.testInputLocationsInternal(2, 1, producerLocations, producerLocations.subList(1, 2), producersToIgnore);
    }

    private void testNoPreferredInputLocationsInternal(int producerParallelism, int consumerParallelism) {
        this.testInputLocationsInternal(producerParallelism, consumerParallelism, Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
    }

    private void testInputLocationsInternal(int producerParallelism, int consumerParallelism, List<TaskManagerLocation> producerLocations, List<TaskManagerLocation> expectedPreferredLocations, Set<Integer> indicesOfProducersToIgnore) {
        JobVertexID producerJobVertexId = new JobVertexID();
        List<ExecutionVertexID> producerIds = IntStream.range(0, producerParallelism).mapToObj(i -> new ExecutionVertexID(producerJobVertexId, i)).collect(Collectors.toList());
        JobVertexID consumerJobVertexId = new JobVertexID();
        List<ExecutionVertexID> consumerIds = IntStream.range(0, consumerParallelism).mapToObj(i -> new ExecutionVertexID(consumerJobVertexId, i)).collect(Collectors.toList());
        TestingInputsLocationsRetriever.Builder locationRetrieverBuilder = new TestingInputsLocationsRetriever.Builder();
        locationRetrieverBuilder.connectConsumersToProducers(consumerIds, producerIds);
        TestingInputsLocationsRetriever inputsLocationsRetriever = locationRetrieverBuilder.build();
        for (int i2 = 0; i2 < producerParallelism; ++i2) {
            LocalTaskManagerLocation producerLocation = producerLocations.isEmpty() ? new LocalTaskManagerLocation() : producerLocations.get(i2);
            inputsLocationsRetriever.assignTaskManagerLocation(producerIds.get(i2), producerLocation);
        }
        this.checkInputLocations(consumerIds.get(0), inputsLocationsRetriever, expectedPreferredLocations, indicesOfProducersToIgnore.stream().map(index -> new ExecutionVertexID(producerJobVertexId, index.intValue())).collect(Collectors.toSet()));
    }

    private void checkInputLocations(ExecutionVertexID consumerId, TestingInputsLocationsRetriever inputsLocationsRetriever, List<TaskManagerLocation> expectedPreferredLocations, Set<ExecutionVertexID> producersToIgnore) {
        DefaultPreferredLocationsRetriever locationsRetriever = new DefaultPreferredLocationsRetriever(id -> Optional.empty(), (InputsLocationsRetriever)inputsLocationsRetriever);
        CompletableFuture preferredLocations = locationsRetriever.getPreferredLocations(consumerId, producersToIgnore);
        Assertions.assertThat((Collection)preferredLocations.getNow(null)).containsExactlyInAnyOrderElementsOf(expectedPreferredLocations);
    }
}

