/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.io.File;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.handler.AbstractHandler;
import org.apache.flink.runtime.rest.handler.FileUploads;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.handler.router.RouteResult;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.runtime.rest.util.TestMessageHeaders;
import org.apache.flink.runtime.rest.util.TestRestHandler;
import org.apache.flink.runtime.rest.util.TestRestServerEndpoint;
import org.apache.flink.runtime.rest.versioning.RuntimeRestAPIVersion;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.util.Attribute;
import org.apache.flink.shaded.netty4.io.netty.util.AttributeKey;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.TestLoggerExtension;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Matchers;
import org.mockito.Mockito;

@ExtendWith(value={TestLoggerExtension.class})
class AbstractHandlerTest {
    private static final RestfulGateway mockRestfulGateway = TestingDispatcherGateway.newBuilder().build();
    private static final GatewayRetriever<RestfulGateway> mockGatewayRetriever = () -> CompletableFuture.completedFuture(mockRestfulGateway);
    private static final Configuration REST_BASE_CONFIG;

    AbstractHandlerTest() {
    }

    private RestClient createRestClient(int serverPort) throws ConfigurationException {
        Configuration config = new Configuration(REST_BASE_CONFIG);
        config.setInteger(RestOptions.PORT, serverPort);
        return new RestClient(config, Executors.directExecutor());
    }

    @Test
    void testOOMErrorMessageEnrichment() throws Exception {
        TestMessageHeaders<EmptyRequestBody, EmptyResponseBody, EmptyMessageParameters> messageHeaders = TestMessageHeaders.emptyBuilder().setTargetRestEndpointURL("/test-handler").build();
        TestRestHandler<RestfulGateway, EmptyRequestBody, EmptyResponseBody, EmptyMessageParameters> testRestHandler = new TestRestHandler<RestfulGateway, EmptyRequestBody, EmptyResponseBody, EmptyMessageParameters>(mockGatewayRetriever, (MessageHeaders<EmptyRequestBody, EmptyResponseBody, EmptyMessageParameters>)messageHeaders, FutureUtils.completedExceptionally((Throwable)new OutOfMemoryError("Metaspace")));
        try (TestRestServerEndpoint server = TestRestServerEndpoint.builder(REST_BASE_CONFIG).withHandler((RestHandlerSpecification)messageHeaders, (ChannelInboundHandler)testRestHandler).buildAndStart();
             RestClient restClient = this.createRestClient(server.getServerAddress().getPort());){
            CompletableFuture response = restClient.sendRequest(server.getServerAddress().getHostName(), server.getServerAddress().getPort(), messageHeaders, (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)EmptyRequestBody.getInstance());
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(response::get).as("An ExecutionException was expected here being caused by the OutOfMemoryError.", new Object[0])).isInstanceOf(ExecutionException.class)).hasMessageContaining("Metaspace. The metaspace out-of-memory error has occurred. ");
        }
    }

    @Test
    void testFileCleanup(@TempDir File temporaryFolder) throws Exception {
        Path dir = temporaryFolder.toPath();
        Path file = dir.resolve("file");
        Files.createFile(file, new FileAttribute[0]);
        TestingRestfulGateway mockRestfulGateway = new TestingRestfulGateway.Builder().build();
        GatewayRetriever mockGatewayRetriever = () -> CompletableFuture.completedFuture(mockRestfulGateway);
        CompletableFuture<Void> requestProcessingCompleteFuture = new CompletableFuture<Void>();
        TestHandler handler = new TestHandler(requestProcessingCompleteFuture, (GatewayRetriever<? extends RestfulGateway>)mockGatewayRetriever);
        RouteResult routeResult = new RouteResult("", "", Collections.emptyMap(), Collections.emptyMap(), (Object)"");
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, TestHandler.TestHeaders.INSTANCE.getTargetRestEndpointURL(), Unpooled.wrappedBuffer((byte[])new byte[0]));
        RoutedRequest routerRequest = new RoutedRequest(routeResult, (HttpRequest)request);
        SimpleAttribute attribute = new SimpleAttribute();
        attribute.set(new FileUploads(dir));
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)channel.attr((AttributeKey)Matchers.any(AttributeKey.class))).thenReturn((Object)attribute);
        ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)context.channel()).thenReturn((Object)channel);
        handler.respondAsLeader(context, routerRequest, mockRestfulGateway);
        Assertions.assertThat((boolean)Files.exists(file, new LinkOption[0])).isTrue();
        requestProcessingCompleteFuture.complete(null);
        Assertions.assertThat((boolean)Files.exists(file, new LinkOption[0])).isFalse();
    }

    static {
        String loopbackAddress = InetAddress.getLoopbackAddress().getHostAddress();
        Configuration config = new Configuration();
        config.setString(RestOptions.BIND_PORT, "0");
        config.setString(RestOptions.BIND_ADDRESS, loopbackAddress);
        config.setString(RestOptions.ADDRESS, loopbackAddress);
        REST_BASE_CONFIG = config;
    }

    private static class TestHandler
    extends AbstractHandler<RestfulGateway, EmptyRequestBody, EmptyMessageParameters> {
        private final CompletableFuture<Void> completionFuture;

        protected TestHandler(CompletableFuture<Void> completionFuture, @Nonnull GatewayRetriever<? extends RestfulGateway> leaderRetriever) {
            super(leaderRetriever, RpcUtils.INF_TIMEOUT, Collections.emptyMap(), (UntypedResponseMessageHeaders)TestHeaders.INSTANCE);
            this.completionFuture = completionFuture;
        }

        protected CompletableFuture<Void> respondToRequest(ChannelHandlerContext ctx, HttpRequest httpRequest, HandlerRequest<EmptyRequestBody> handlerRequest, RestfulGateway gateway) throws RestHandlerException {
            return this.completionFuture;
        }

        private static enum TestHeaders implements UntypedResponseMessageHeaders<EmptyRequestBody, EmptyMessageParameters>
        {
            INSTANCE;


            public Class<EmptyRequestBody> getRequestClass() {
                return EmptyRequestBody.class;
            }

            public EmptyMessageParameters getUnresolvedMessageParameters() {
                return EmptyMessageParameters.getInstance();
            }

            public HttpMethodWrapper getHttpMethod() {
                return HttpMethodWrapper.POST;
            }

            public String getTargetRestEndpointURL() {
                return "/test";
            }

            public boolean acceptsFileUploads() {
                return true;
            }

            public Collection<RuntimeRestAPIVersion> getSupportedAPIVersions() {
                return Collections.singleton(RuntimeRestAPIVersion.V1);
            }
        }
    }

    private static class SimpleAttribute
    implements Attribute<FileUploads> {
        private static final AttributeKey<FileUploads> KEY = AttributeKey.valueOf((String)"test");
        private final AtomicReference<FileUploads> container = new AtomicReference();

        private SimpleAttribute() {
        }

        public AttributeKey<FileUploads> key() {
            return KEY;
        }

        public FileUploads get() {
            return this.container.get();
        }

        public void set(FileUploads value) {
            this.container.set(value);
        }

        public FileUploads getAndSet(FileUploads value) {
            return this.container.getAndSet(value);
        }

        public FileUploads setIfAbsent(FileUploads value) {
            if (this.container.compareAndSet(null, value)) {
                return value;
            }
            return this.container.get();
        }

        public FileUploads getAndRemove() {
            return this.container.getAndSet(null);
        }

        public boolean compareAndSet(FileUploads oldValue, FileUploads newValue) {
            return this.container.compareAndSet(oldValue, newValue);
        }

        public void remove() {
            this.set(null);
        }
    }
}

