/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.math.BigDecimal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SlotManagerConfigurationTest {
    SlotManagerConfigurationTest() {
    }

    @Test
    void testSetSlotRequestTimeout() throws Exception {
        long slotIdleTimeout = 42L;
        Configuration configuration = new Configuration();
        configuration.setLong(JobManagerOptions.SLOT_REQUEST_TIMEOUT, 42L);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)WorkerResourceSpec.ZERO);
        Assertions.assertThat((long)42L).isEqualTo(slotManagerConfiguration.getSlotRequestTimeout().toMilliseconds());
    }

    @Test
    void testPreferLegacySlotRequestTimeout() throws Exception {
        long legacySlotIdleTimeout = 42L;
        Configuration configuration = new Configuration();
        configuration.setLong(ResourceManagerOptions.SLOT_REQUEST_TIMEOUT, 42L);
        configuration.setLong(JobManagerOptions.SLOT_REQUEST_TIMEOUT, 300000L);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)WorkerResourceSpec.ZERO);
        Assertions.assertThat((long)42L).isEqualTo(slotManagerConfiguration.getSlotRequestTimeout().toMilliseconds());
    }

    @Test
    void testComputeMaxTotalCpu() throws Exception {
        Configuration configuration = new Configuration();
        int maxSlotNum = 9;
        int numSlots = 3;
        double cpuCores = 10.0;
        configuration.set(ResourceManagerOptions.MAX_SLOT_NUM, (Object)9);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)new WorkerResourceSpec.Builder().setNumSlots(3).setCpuCores(10.0).build());
        Assertions.assertThat((double)slotManagerConfiguration.getMaxTotalCpu().getValue().doubleValue()).isEqualTo(30.0);
    }

    @Test
    void testComputeMaxTotalMemory() throws Exception {
        Configuration configuration = new Configuration();
        int maxSlotNum = 1000000;
        int numSlots = 10;
        int totalTaskManagerMB = MemorySize.parse((String)"1", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.TERA_BYTES).getMebiBytes();
        configuration.set(ResourceManagerOptions.MAX_SLOT_NUM, (Object)1000000);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)new WorkerResourceSpec.Builder().setNumSlots(10).setTaskHeapMemoryMB(totalTaskManagerMB).build());
        Assertions.assertThat((long)slotManagerConfiguration.getMaxTotalMem().getBytes()).isEqualTo(BigDecimal.valueOf(MemorySize.ofMebiBytes((long)totalTaskManagerMB).getBytes()).multiply(BigDecimal.valueOf(1000000L)).divide(BigDecimal.valueOf(10L)).longValue());
    }
}

