/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceAllocationStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerId;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocationResult;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerResourceInfoProvider;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingTaskManagerInfo;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingTaskManagerResourceInfoProvider;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.util.ResourceCounter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultResourceAllocationStrategyTest {
    private static final ResourceProfile DEFAULT_SLOT_RESOURCE = ResourceProfile.fromResources((double)1.0, (int)100);
    private static final int NUM_OF_SLOTS = 5;
    private static final DefaultResourceAllocationStrategy STRATEGY = new DefaultResourceAllocationStrategy(DEFAULT_SLOT_RESOURCE.multiply(5), 5);

    DefaultResourceAllocationStrategyTest() {
    }

    @Test
    void testFulfillRequirementWithRegisteredResources() {
        TestingTaskManagerInfo taskManager = new TestingTaskManagerInfo(DEFAULT_SLOT_RESOURCE.multiply(10), DEFAULT_SLOT_RESOURCE.multiply(10), DEFAULT_SLOT_RESOURCE);
        JobID jobId = new JobID();
        ArrayList<ResourceRequirement> requirements = new ArrayList<ResourceRequirement>();
        ResourceProfile largeResource = DEFAULT_SLOT_RESOURCE.multiply(8);
        TestingTaskManagerResourceInfoProvider taskManagerResourceInfoProvider = TestingTaskManagerResourceInfoProvider.newBuilder().setRegisteredTaskManagersSupplier(() -> Collections.singleton(taskManager)).build();
        requirements.add(ResourceRequirement.create((ResourceProfile)largeResource, (int)1));
        requirements.add(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)2));
        ResourceAllocationResult result = STRATEGY.tryFulfillRequirements(Collections.singletonMap(jobId, requirements), (TaskManagerResourceInfoProvider)taskManagerResourceInfoProvider, resourceID -> false);
        Assertions.assertThat((Collection)result.getUnfulfillableJobs()).isEmpty();
        Assertions.assertThat((Map)result.getAllocationsOnPendingResources()).isEmpty();
        Assertions.assertThat((List)result.getPendingTaskManagersToAllocate()).isEmpty();
        Assertions.assertThat((int)((ResourceCounter)((Map)result.getAllocationsOnRegisteredResources().get(jobId)).get(taskManager.getInstanceId())).getResourceCount(DEFAULT_SLOT_RESOURCE)).isEqualTo(2);
        Assertions.assertThat((int)((ResourceCounter)((Map)result.getAllocationsOnRegisteredResources().get(jobId)).get(taskManager.getInstanceId())).getResourceCount(largeResource)).isEqualTo(1);
    }

    @Test
    void testFulfillRequirementWithPendingResources() {
        JobID jobId = new JobID();
        ArrayList<ResourceRequirement> requirements = new ArrayList<ResourceRequirement>();
        ResourceProfile largeResource = DEFAULT_SLOT_RESOURCE.multiply(3);
        PendingTaskManager pendingTaskManager = new PendingTaskManager(DEFAULT_SLOT_RESOURCE.multiply(5), 5);
        TestingTaskManagerResourceInfoProvider taskManagerResourceInfoProvider = TestingTaskManagerResourceInfoProvider.newBuilder().setPendingTaskManagersSupplier(() -> Collections.singleton(pendingTaskManager)).build();
        requirements.add(ResourceRequirement.create((ResourceProfile)largeResource, (int)2));
        requirements.add(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)4));
        ResourceAllocationResult result = STRATEGY.tryFulfillRequirements(Collections.singletonMap(jobId, requirements), (TaskManagerResourceInfoProvider)taskManagerResourceInfoProvider, resourceID -> false);
        Assertions.assertThat((Collection)result.getUnfulfillableJobs()).isEmpty();
        Assertions.assertThat((Map)result.getAllocationsOnRegisteredResources()).isEmpty();
        Assertions.assertThat((List)result.getPendingTaskManagersToAllocate()).hasSize(1);
        PendingTaskManagerId newAllocated = ((PendingTaskManager)result.getPendingTaskManagersToAllocate().get(0)).getPendingTaskManagerId();
        ResourceCounter allFulfilledRequirements = ResourceCounter.empty();
        for (Map.Entry resourceWithCount : ((ResourceCounter)((Map)result.getAllocationsOnPendingResources().get(pendingTaskManager.getPendingTaskManagerId())).get(jobId)).getResourcesWithCount()) {
            allFulfilledRequirements = allFulfilledRequirements.add((ResourceProfile)resourceWithCount.getKey(), ((Integer)resourceWithCount.getValue()).intValue());
        }
        for (Map.Entry resourceWithCount : ((ResourceCounter)((Map)result.getAllocationsOnPendingResources().get(newAllocated)).get(jobId)).getResourcesWithCount()) {
            allFulfilledRequirements = allFulfilledRequirements.add((ResourceProfile)resourceWithCount.getKey(), ((Integer)resourceWithCount.getValue()).intValue());
        }
        Assertions.assertThat((int)allFulfilledRequirements.getResourceCount(DEFAULT_SLOT_RESOURCE)).isEqualTo(4);
        Assertions.assertThat((int)allFulfilledRequirements.getResourceCount(largeResource)).isEqualTo(2);
    }

    @Test
    void testUnfulfillableRequirement() {
        TestingTaskManagerInfo taskManager = new TestingTaskManagerInfo(DEFAULT_SLOT_RESOURCE.multiply(5), DEFAULT_SLOT_RESOURCE.multiply(5), DEFAULT_SLOT_RESOURCE);
        JobID jobId = new JobID();
        ArrayList<ResourceRequirement> requirements = new ArrayList<ResourceRequirement>();
        ResourceProfile unfulfillableResource = DEFAULT_SLOT_RESOURCE.multiply(8);
        TestingTaskManagerResourceInfoProvider taskManagerResourceInfoProvider = TestingTaskManagerResourceInfoProvider.newBuilder().setRegisteredTaskManagersSupplier(() -> Collections.singleton(taskManager)).build();
        requirements.add(ResourceRequirement.create((ResourceProfile)unfulfillableResource, (int)1));
        ResourceAllocationResult result = STRATEGY.tryFulfillRequirements(Collections.singletonMap(jobId, requirements), (TaskManagerResourceInfoProvider)taskManagerResourceInfoProvider, resourceID -> false);
        Assertions.assertThat((Collection)result.getUnfulfillableJobs()).containsExactly((Object[])new JobID[]{jobId});
        Assertions.assertThat((List)result.getPendingTaskManagersToAllocate()).isEmpty();
    }

    @Test
    void testBlockedTaskManagerCannotFulfillRequirements() {
        TestingTaskManagerInfo registeredTaskManager = new TestingTaskManagerInfo(DEFAULT_SLOT_RESOURCE.multiply(5), DEFAULT_SLOT_RESOURCE.multiply(5), DEFAULT_SLOT_RESOURCE);
        JobID jobId = new JobID();
        ArrayList<ResourceRequirement> requirements = new ArrayList<ResourceRequirement>();
        TestingTaskManagerResourceInfoProvider taskManagerResourceInfoProvider = TestingTaskManagerResourceInfoProvider.newBuilder().setRegisteredTaskManagersSupplier(() -> Collections.singleton(registeredTaskManager)).build();
        requirements.add(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)10));
        ResourceAllocationResult result = STRATEGY.tryFulfillRequirements(Collections.singletonMap(jobId, requirements), (TaskManagerResourceInfoProvider)taskManagerResourceInfoProvider, arg_0 -> ((ResourceID)registeredTaskManager.getTaskExecutorConnection().getResourceID()).equals(arg_0));
        Assertions.assertThat((Collection)result.getUnfulfillableJobs()).isEmpty();
        Assertions.assertThat((Map)result.getAllocationsOnRegisteredResources()).isEmpty();
        Assertions.assertThat((List)result.getPendingTaskManagersToAllocate()).hasSize(2);
    }
}

