/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.drivers;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.GroupReduceDriver;
import org.apache.flink.runtime.operators.drivers.DriverTestData;
import org.apache.flink.runtime.operators.drivers.GatheringCollector;
import org.apache.flink.runtime.operators.drivers.TestTaskContext;
import org.apache.flink.runtime.util.EmptyMutableObjectIterator;
import org.apache.flink.runtime.util.RegularToMutableObjectIterator;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;
import org.junit.Test;

public class GroupReduceDriverTest {
    @Test
    public void testAllReduceDriverImmutableEmpty() {
        try {
            TestTaskContext context = new TestTaskContext();
            List<Tuple2<String, Integer>> data = DriverTestData.createReduceImmutableData();
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeExtractor.getForObject(data.get(0));
            MutableObjectIterator input = EmptyMutableObjectIterator.get();
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            context.setDriverStrategy(DriverStrategy.SORTED_GROUP_REDUCE);
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer(new ExecutionConfig()));
            context.setInput1(input, typeInfo.createSerializer(new ExecutionConfig()));
            context.setComparator1(comparator);
            context.setCollector(result);
            GroupReduceDriver driver = new GroupReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Assert.assertTrue((boolean)result.getList().isEmpty());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAllReduceDriverImmutable() {
        try {
            TestTaskContext context = new TestTaskContext();
            List<Tuple2<String, Integer>> data = DriverTestData.createReduceImmutableData();
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeExtractor.getForObject(data.get(0));
            RegularToMutableObjectIterator input = new RegularToMutableObjectIterator(data.iterator(), (TypeSerializer)typeInfo.createSerializer(new ExecutionConfig()));
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer(new ExecutionConfig()));
            context.setDriverStrategy(DriverStrategy.SORTED_GROUP_REDUCE);
            context.setInput1(input, typeInfo.createSerializer(new ExecutionConfig()));
            context.setCollector(result);
            context.setComparator1(comparator);
            context.setUdf(new ConcatSumReducer());
            GroupReduceDriver driver = new GroupReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Object[] res = result.getList().toArray();
            Object[] expected = DriverTestData.createReduceImmutableDataGroupedResult().toArray();
            DriverTestData.compareTupleArrays(expected, res);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAllReduceDriverMutable() {
        try {
            TestTaskContext context = new TestTaskContext();
            List<Tuple2<StringValue, IntValue>> data = DriverTestData.createReduceMutableData();
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeExtractor.getForObject(data.get(0));
            RegularToMutableObjectIterator input = new RegularToMutableObjectIterator(data.iterator(), (TypeSerializer)typeInfo.createSerializer(new ExecutionConfig()));
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer(new ExecutionConfig()));
            context.setDriverStrategy(DriverStrategy.SORTED_GROUP_REDUCE);
            context.setInput1(input, typeInfo.createSerializer(new ExecutionConfig()));
            context.setComparator1(comparator);
            context.setCollector(result);
            context.setUdf(new ConcatSumMutableReducer());
            GroupReduceDriver driver = new GroupReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Object[] res = result.getList().toArray();
            Object[] expected = DriverTestData.createReduceMutableDataGroupedResult().toArray();
            DriverTestData.compareTupleArrays(expected, res);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAllReduceDriverIncorrectlyAccumulatingMutable() {
        try {
            TestTaskContext context = new TestTaskContext();
            List<Tuple2<StringValue, IntValue>> data = DriverTestData.createReduceMutableData();
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeExtractor.getForObject(data.get(0));
            RegularToMutableObjectIterator input = new RegularToMutableObjectIterator(data.iterator(), (TypeSerializer)typeInfo.createSerializer(new ExecutionConfig()));
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer(new ExecutionConfig()));
            context.setDriverStrategy(DriverStrategy.SORTED_GROUP_REDUCE);
            context.setInput1(input, typeInfo.createSerializer(new ExecutionConfig()));
            context.setComparator1(comparator);
            context.setCollector(result);
            context.setUdf(new ConcatSumMutableAccumulatingReducer());
            GroupReduceDriver driver = new GroupReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Object[] res = result.getList().toArray();
            Object[] expected = DriverTestData.createReduceMutableDataGroupedResult().toArray();
            try {
                DriverTestData.compareTupleArrays(expected, res);
                Assert.fail((String)"Accumulationg mutable objects is expected to result in incorrect values.");
            }
            catch (AssertionError assertionError) {}
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAllReduceDriverAccumulatingImmutable() {
        try {
            TestTaskContext context = new TestTaskContext();
            List<Tuple2<StringValue, IntValue>> data = DriverTestData.createReduceMutableData();
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeExtractor.getForObject(data.get(0));
            RegularToMutableObjectIterator input = new RegularToMutableObjectIterator(data.iterator(), (TypeSerializer)typeInfo.createSerializer(new ExecutionConfig()));
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer(new ExecutionConfig()));
            context.setDriverStrategy(DriverStrategy.SORTED_GROUP_REDUCE);
            context.setInput1(input, typeInfo.createSerializer(new ExecutionConfig()));
            context.setComparator1(comparator);
            context.setCollector(result);
            context.setUdf(new ConcatSumMutableAccumulatingReducer());
            context.setMutableObjectMode(false);
            GroupReduceDriver driver = new GroupReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Object[] res = result.getList().toArray();
            Object[] expected = DriverTestData.createReduceMutableDataGroupedResult().toArray();
            DriverTestData.compareTupleArrays(expected, res);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static final class ConcatSumMutableAccumulatingReducer
    implements GroupReduceFunction<Tuple2<StringValue, IntValue>, Tuple2<StringValue, IntValue>> {
        public void reduce(Iterable<Tuple2<StringValue, IntValue>> values, Collector<Tuple2<StringValue, IntValue>> out) throws Exception {
            ArrayList<Tuple2<StringValue, IntValue>> all = new ArrayList<Tuple2<StringValue, IntValue>>();
            for (Tuple2<StringValue, IntValue> t : values) {
                all.add(t);
            }
            Tuple2 result = (Tuple2)all.get(0);
            for (int i = 1; i < all.size(); ++i) {
                Tuple2 e = (Tuple2)all.get(i);
                ((StringValue)result.f0).append((StringValue)e.f0);
                ((IntValue)result.f1).setValue(((IntValue)result.f1).getValue() + ((IntValue)e.f1).getValue());
            }
            out.collect((Object)result);
        }
    }

    public static final class ConcatSumMutableReducer
    extends RichGroupReduceFunction<Tuple2<StringValue, IntValue>, Tuple2<StringValue, IntValue>> {
        public void reduce(Iterable<Tuple2<StringValue, IntValue>> values, Collector<Tuple2<StringValue, IntValue>> out) {
            Tuple2<StringValue, IntValue> current = new Tuple2<StringValue, IntValue>((Object)new StringValue((CharSequence)""), (Object)new IntValue(0));
            for (Tuple2<StringValue, IntValue> next : values) {
                ((StringValue)next.f0).append((StringValue)current.f0);
                ((IntValue)next.f1).setValue(((IntValue)current.f1).getValue() + ((IntValue)next.f1).getValue());
                current = next;
            }
            out.collect((Object)current);
        }
    }

    public static final class ConcatSumReducer
    extends RichGroupReduceFunction<Tuple2<String, Integer>, Tuple2<String, Integer>> {
        public void reduce(Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) {
            Tuple2<String, Integer> current = new Tuple2<String, Integer>((Object)"", (Object)0);
            for (Tuple2<String, Integer> next : values) {
                next.f0 = (String)current.f0 + (String)next.f0;
                next.f1 = (Integer)current.f1 + (Integer)next.f1;
                current = next;
            }
            out.collect((Object)current);
        }
    }
}

