/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TaskManagerMetricGroupTest {
    private static final JobID JOB_ID = new JobID();
    private static final String JOB_NAME = "test job";
    private TaskManagerMetricGroup metricGroup;

    @BeforeEach
    public void before() {
        this.metricGroup = new TaskManagerMetricGroup(NoOpMetricRegistry.INSTANCE, "testHost", "testTm");
    }

    @AfterEach
    public void after() {
        if (!this.metricGroup.isClosed()) {
            this.metricGroup.close();
        }
    }

    @Test
    public void testGetSameJob() {
        Assertions.assertSame((Object)this.metricGroup.addJob(JOB_ID, JOB_NAME), (Object)this.metricGroup.addJob(JOB_ID, JOB_NAME));
        Assertions.assertNotSame((Object)this.metricGroup.addJob(JOB_ID, JOB_NAME), (Object)this.metricGroup.addJob(new JobID(), "another job"));
    }

    @Test
    public void testReCreateAfterRemoval() {
        TaskManagerJobMetricGroup oldGroup = this.metricGroup.addJob(JOB_ID, JOB_NAME);
        this.metricGroup.removeJobMetricsGroup(JOB_ID);
        Assertions.assertNotSame((Object)oldGroup, (Object)this.metricGroup.addJob(JOB_ID, JOB_NAME));
    }

    @Test
    public void testCloseOnRemove() {
        TaskManagerJobMetricGroup tmJobMetricGroup = this.metricGroup.addJob(JOB_ID, JOB_NAME);
        this.metricGroup.removeJobMetricsGroup(JOB_ID);
        Assertions.assertTrue((boolean)tmJobMetricGroup.isClosed());
    }

    @Test
    public void testCloseWithoutRemoval() {
        TaskManagerJobMetricGroup jobGroup = this.metricGroup.addJob(JOB_ID, JOB_NAME);
        this.metricGroup.close();
        Assertions.assertTrue((boolean)jobGroup.isClosed());
    }

    @Test
    public void testRemoveNullJobID() {
        this.metricGroup.removeJobMetricsGroup(null);
    }

    @Test
    public void testRemoveInvalidJobID() {
        this.metricGroup.removeJobMetricsGroup(JOB_ID);
    }
}

