/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingContender;
import org.apache.flink.runtime.leaderelection.TestingListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class StandaloneLeaderElectionTest
extends TestLogger {
    private static final String TEST_URL = "akka://users/jobmanager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStandaloneLeaderElectionRetrieval() throws Exception {
        StandaloneLeaderElectionService leaderElectionService = new StandaloneLeaderElectionService();
        StandaloneLeaderRetrievalService leaderRetrievalService = new StandaloneLeaderRetrievalService(TEST_URL);
        TestingContender contender = new TestingContender(TEST_URL, (LeaderElectionService)leaderElectionService);
        TestingListener testingListener = new TestingListener();
        try {
            leaderElectionService.start((LeaderContender)contender);
            leaderRetrievalService.start((LeaderRetrievalListener)testingListener);
            contender.waitForLeader();
            Assert.assertTrue((boolean)contender.isLeader());
            Assert.assertEquals((Object)HighAvailabilityServices.DEFAULT_LEADER_ID, (Object)contender.getLeaderSessionID());
            testingListener.waitForNewLeader();
            Assert.assertEquals((Object)TEST_URL, (Object)testingListener.getAddress());
            Assert.assertEquals((Object)HighAvailabilityServices.DEFAULT_LEADER_ID, (Object)testingListener.getLeaderSessionID());
        }
        finally {
            leaderElectionService.stop();
            leaderRetrievalService.stop();
        }
    }
}

