/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderImpl;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderResource;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequest;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;

public class PhysicalSlotProviderImplWithDefaultSlotSelectionStrategyTest
extends TestLogger {
    @Rule
    public final PhysicalSlotProviderResource physicalSlotProviderResource = new PhysicalSlotProviderResource((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault());

    @Test
    public void testSlotAllocationFulfilledWithAvailableSlots() throws InterruptedException, ExecutionException {
        PhysicalSlotRequest request = this.physicalSlotProviderResource.createSimpleRequest();
        this.physicalSlotProviderResource.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY);
        CompletableFuture<PhysicalSlotRequest.Result> slotFuture = this.physicalSlotProviderResource.allocateSlot(request);
        PhysicalSlotRequest.Result result = slotFuture.get();
        MatcherAssert.assertThat((Object)result.getSlotRequestId(), (Matcher)Matchers.is((Object)request.getSlotRequestId()));
    }

    @Test
    public void testSlotAllocationFulfilledWithNewSlots() throws ExecutionException, InterruptedException {
        CompletableFuture<PhysicalSlotRequest.Result> slotFuture = this.physicalSlotProviderResource.allocateSlot(this.physicalSlotProviderResource.createSimpleRequest());
        MatcherAssert.assertThat((Object)slotFuture.isDone(), (Matcher)Matchers.is((Object)false));
        this.physicalSlotProviderResource.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY);
        slotFuture.get();
    }

    @Test
    public void testIndividualBatchSlotRequestTimeoutCheckIsDisabledOnAllocatingNewSlots() throws Exception {
        DeclarativeSlotPoolBridge slotPool = new DeclarativeSlotPoolBridgeBuilder().buildAndStart(this.physicalSlotProviderResource.getMainThreadExecutor());
        MatcherAssert.assertThat((Object)slotPool.isBatchSlotRequestTimeoutCheckEnabled(), (Matcher)Matchers.is((Object)true));
        PhysicalSlotProviderImpl slotProvider = new PhysicalSlotProviderImpl((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault(), (SlotPool)slotPool);
        slotProvider.disableBatchSlotRequestTimeoutCheck();
        MatcherAssert.assertThat((Object)slotPool.isBatchSlotRequestTimeoutCheckEnabled(), (Matcher)Matchers.is((Object)false));
    }
}

