/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexSpilledRegionManager;

public class TestingFileDataIndexSpilledRegionManager
implements HsFileDataIndexSpilledRegionManager {
    private final List<TreeMap<Integer, HsFileDataIndexImpl.InternalRegion>> regions = new ArrayList<TreeMap<Integer, HsFileDataIndexImpl.InternalRegion>>();
    private final BiConsumer<Integer, HsFileDataIndexImpl.InternalRegion> cacheRegionConsumer;
    private int findRegionInvoked = 0;

    public TestingFileDataIndexSpilledRegionManager(int numSubpartitions, BiConsumer<Integer, HsFileDataIndexImpl.InternalRegion> cacheRegionConsumer) {
        this.cacheRegionConsumer = cacheRegionConsumer;
        for (int i = 0; i < numSubpartitions; ++i) {
            this.regions.add(new TreeMap());
        }
    }

    @Nullable
    public HsFileDataIndexImpl.InternalRegion getRegion(int subpartition, int bufferIndex) {
        return this.regions.get(subpartition).get(bufferIndex);
    }

    public int getSpilledRegionSize(int subpartition) {
        return this.regions.get(subpartition).size();
    }

    public int getFindRegionInvoked() {
        return this.findRegionInvoked;
    }

    public void appendOrOverwriteRegion(int subpartition, HsFileDataIndexImpl.InternalRegion region) throws IOException {
        this.regions.get(subpartition).put(region.getFirstBufferIndex(), region);
    }

    public long findRegion(int subpartition, int bufferIndex, boolean loadToCache) {
        ++this.findRegionInvoked;
        HsFileDataIndexImpl.InternalRegion region = this.regions.get(subpartition).get(bufferIndex);
        if (region == null) {
            return -1L;
        }
        if (loadToCache) {
            this.cacheRegionConsumer.accept(subpartition, region);
        }
        return 1L;
    }

    public void close() throws IOException {
    }

    public static class Factory
    implements HsFileDataIndexSpilledRegionManager.Factory {
        public static final Factory INSTANCE = new Factory();
        public TestingFileDataIndexSpilledRegionManager lastSpilledRegionManager;

        public TestingFileDataIndexSpilledRegionManager getLastSpilledRegionManager() {
            return this.lastSpilledRegionManager;
        }

        public HsFileDataIndexSpilledRegionManager create(int numSubpartitions, Path indexFilePath, BiConsumer<Integer, HsFileDataIndexImpl.InternalRegion> cacheRegionConsumer) {
            TestingFileDataIndexSpilledRegionManager testingFileDataIndexSpilledRegionManager;
            this.lastSpilledRegionManager = testingFileDataIndexSpilledRegionManager = new TestingFileDataIndexSpilledRegionManager(numSubpartitions, cacheRegionConsumer);
            return testingFileDataIndexSpilledRegionManager;
        }
    }
}

