/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.externalresource;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.ResettableIterator;
import org.apache.flink.api.common.externalresource.ExternalResourceDriverFactory;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.TestingPluginManager;
import org.apache.flink.runtime.externalresource.ExternalResourceUtils;
import org.apache.flink.runtime.externalresource.StaticExternalResourceInfoProvider;
import org.apache.flink.runtime.externalresource.TestingExternalResourceDriver;
import org.apache.flink.runtime.externalresource.TestingExternalResourceDriverFactory;
import org.apache.flink.runtime.externalresource.TestingFailedExternalResourceDriverFactory;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;

public class ExternalResourceUtilsTest
extends TestLogger {
    private static final String RESOURCE_NAME_1 = "foo";
    private static final String RESOURCE_NAME_2 = "bar";
    private static final List<String> RESOURCE_LIST = Arrays.asList("foo", "bar");
    private static final long RESOURCE_AMOUNT_1 = 2L;
    private static final long RESOURCE_AMOUNT_2 = 1L;
    private static final String RESOURCE_CONFIG_KEY_1 = "flink1";
    private static final String RESOURCE_CONFIG_KEY_2 = "flink2";
    private static final String SUFFIX = "flink.config-key";

    @Test
    public void testGetExternalResourceConfigurationKeysWithConfigKeyNotSpecifiedOrEmpty() {
        Configuration config = new Configuration();
        String resourceConfigKey = "";
        config.set(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST, RESOURCE_LIST);
        config.setString(ExternalResourceOptions.getSystemConfigKeyConfigOptionForResource((String)RESOURCE_NAME_1, (String)SUFFIX), "");
        Map configMap = ExternalResourceUtils.getExternalResourceConfigurationKeys((Configuration)config, (String)SUFFIX);
        Assert.assertThat(configMap.entrySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testGetExternalResourceConfigurationKeysWithConflictConfigKey() {
        Configuration config = new Configuration();
        config.set(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST, RESOURCE_LIST);
        config.setString(ExternalResourceOptions.getSystemConfigKeyConfigOptionForResource((String)RESOURCE_NAME_1, (String)SUFFIX), RESOURCE_CONFIG_KEY_1);
        config.setString(ExternalResourceOptions.getSystemConfigKeyConfigOptionForResource((String)RESOURCE_NAME_2, (String)SUFFIX), RESOURCE_CONFIG_KEY_1);
        Map configMap = ExternalResourceUtils.getExternalResourceConfigurationKeys((Configuration)config, (String)SUFFIX);
        Assert.assertThat((Object)configMap.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(configMap.values(), (Matcher)Matchers.contains((Object[])new String[]{RESOURCE_CONFIG_KEY_1}));
    }

    @Test
    public void testConstructExternalResourceDriversFromConfig() {
        Configuration config = new Configuration();
        String driverFactoryClassName = TestingExternalResourceDriverFactory.class.getName();
        HashMap<Class<ExternalResourceDriverFactory>, ResettableIterator> plugins = new HashMap<Class<ExternalResourceDriverFactory>, ResettableIterator>();
        plugins.put(ExternalResourceDriverFactory.class, IteratorUtils.singletonIterator((Object)new TestingExternalResourceDriverFactory()));
        TestingPluginManager testingPluginManager = new TestingPluginManager(plugins);
        config.set(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST, Collections.singletonList(RESOURCE_NAME_1));
        config.setString(ExternalResourceOptions.getExternalResourceDriverFactoryConfigOptionForResource((String)RESOURCE_NAME_1), driverFactoryClassName);
        Map externalResourceDrivers = ExternalResourceUtils.externalResourceDriversFromConfig((Configuration)config, (PluginManager)testingPluginManager);
        Assert.assertThat((Object)externalResourceDrivers.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(externalResourceDrivers.get(RESOURCE_NAME_1), (Matcher)IsInstanceOf.instanceOf(TestingExternalResourceDriver.class));
    }

    @Test
    public void testNotConfiguredFactoryClass() {
        Configuration config = new Configuration();
        HashMap<Class<ExternalResourceDriverFactory>, ResettableIterator> plugins = new HashMap<Class<ExternalResourceDriverFactory>, ResettableIterator>();
        plugins.put(ExternalResourceDriverFactory.class, IteratorUtils.singletonIterator((Object)new TestingExternalResourceDriverFactory()));
        TestingPluginManager testingPluginManager = new TestingPluginManager(plugins);
        config.set(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST, Collections.singletonList(RESOURCE_NAME_1));
        Map externalResourceDrivers = ExternalResourceUtils.externalResourceDriversFromConfig((Configuration)config, (PluginManager)testingPluginManager);
        Assert.assertThat(externalResourceDrivers.entrySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testFactoryPluginDoesNotExist() {
        Configuration config = new Configuration();
        String driverFactoryClassName = TestingExternalResourceDriverFactory.class.getName();
        TestingPluginManager testingPluginManager = new TestingPluginManager(Collections.emptyMap());
        config.set(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST, Collections.singletonList(RESOURCE_NAME_1));
        config.setString(ExternalResourceOptions.getExternalResourceDriverFactoryConfigOptionForResource((String)RESOURCE_NAME_1), driverFactoryClassName);
        Map externalResourceDrivers = ExternalResourceUtils.externalResourceDriversFromConfig((Configuration)config, (PluginManager)testingPluginManager);
        Assert.assertThat(externalResourceDrivers.entrySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testFactoryFailedToCreateDriver() {
        Configuration config = new Configuration();
        String driverFactoryClassName = TestingFailedExternalResourceDriverFactory.class.getName();
        HashMap<Class<ExternalResourceDriverFactory>, ResettableIterator> plugins = new HashMap<Class<ExternalResourceDriverFactory>, ResettableIterator>();
        plugins.put(ExternalResourceDriverFactory.class, IteratorUtils.singletonIterator((Object)new TestingFailedExternalResourceDriverFactory()));
        TestingPluginManager testingPluginManager = new TestingPluginManager(plugins);
        config.set(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST, Collections.singletonList(RESOURCE_NAME_1));
        config.setString(ExternalResourceOptions.getExternalResourceDriverFactoryConfigOptionForResource((String)RESOURCE_NAME_1), driverFactoryClassName);
        Map externalResourceDrivers = ExternalResourceUtils.externalResourceDriversFromConfig((Configuration)config, (PluginManager)testingPluginManager);
        Assert.assertThat(externalResourceDrivers.entrySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testGetExternalResourceInfoProvider() {
        HashMap<String, Long> externalResourceAmountMap = new HashMap<String, Long>();
        HashMap<String, TestingExternalResourceDriver> externalResourceDrivers = new HashMap<String, TestingExternalResourceDriver>();
        externalResourceAmountMap.put(RESOURCE_NAME_1, 2L);
        externalResourceDrivers.put(RESOURCE_NAME_1, new TestingExternalResourceDriver());
        StaticExternalResourceInfoProvider externalResourceInfoProvider = (StaticExternalResourceInfoProvider)ExternalResourceUtils.createStaticExternalResourceInfoProvider(externalResourceAmountMap, externalResourceDrivers);
        Assert.assertNotNull(externalResourceInfoProvider.getExternalResources().get(RESOURCE_NAME_1));
    }

    @Test
    public void testGetExternalResourceInfoProviderWithoutAmount() {
        HashMap externalResourceAmountMap = new HashMap();
        HashMap<String, TestingExternalResourceDriver> externalResourceDrivers = new HashMap<String, TestingExternalResourceDriver>();
        externalResourceDrivers.put(RESOURCE_NAME_1, new TestingExternalResourceDriver());
        StaticExternalResourceInfoProvider externalResourceInfoProvider = (StaticExternalResourceInfoProvider)ExternalResourceUtils.createStaticExternalResourceInfoProvider(externalResourceAmountMap, externalResourceDrivers);
        Assert.assertThat(externalResourceInfoProvider.getExternalResources().entrySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testGetExternalResourceAmountMap() {
        Configuration config = new Configuration();
        config.set(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST, Collections.singletonList(RESOURCE_NAME_1));
        config.setLong(ExternalResourceOptions.getAmountConfigOptionForResource((String)RESOURCE_NAME_1), 2L);
        Map externalResourceAmountMap = ExternalResourceUtils.getExternalResourceAmountMap((Configuration)config);
        Assert.assertThat((Object)externalResourceAmountMap.size(), (Matcher)Is.is((Object)1));
        Assert.assertTrue((boolean)externalResourceAmountMap.containsKey(RESOURCE_NAME_1));
        Assert.assertThat(externalResourceAmountMap.get(RESOURCE_NAME_1), (Matcher)Is.is((Object)2L));
    }

    @Test
    public void testGetExternalResourceAmountMapWithIllegalAmount() {
        Configuration config = new Configuration();
        config.set(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST, Collections.singletonList(RESOURCE_NAME_1));
        config.setLong(ExternalResourceOptions.getAmountConfigOptionForResource((String)RESOURCE_NAME_1), 0L);
        Map externalResourceAmountMap = ExternalResourceUtils.getExternalResourceAmountMap((Configuration)config);
        Assert.assertThat(externalResourceAmountMap.entrySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testGetExternalResourcesCollection() {
        Configuration config = new Configuration();
        config.set(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST, Collections.singletonList(RESOURCE_NAME_1));
        config.setLong(ExternalResourceOptions.getAmountConfigOptionForResource((String)RESOURCE_NAME_1), 2L);
        Collection externalResources = ExternalResourceUtils.getExternalResourcesCollection((Configuration)config);
        Assert.assertThat((Object)externalResources.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)externalResources, (Matcher)Matchers.contains((Object[])new ExternalResource[]{new ExternalResource(RESOURCE_NAME_1, 2.0)}));
    }

    @Test
    public void testRecognizeEmptyResourceList() {
        Configuration config = new Configuration();
        config.setString(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST.key(), "none");
        config.setLong(ExternalResourceOptions.getAmountConfigOptionForResource((String)RESOURCE_NAME_1), 2L);
        Collection externalResources = ExternalResourceUtils.getExternalResourcesCollection((Configuration)config);
        Assert.assertThat((Object)externalResources, (Matcher)Is.is((Matcher)Matchers.empty()));
    }
}

