/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphID;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionAttemptIDTest {
    private static final NettyBufferPool ALLOCATOR = new NettyBufferPool(1);

    @Test
    public void testByteBufWriteAndRead() {
        ExecutionAttemptID executionAttemptID = new ExecutionAttemptID(new ExecutionGraphID(), new ExecutionVertexID(new JobVertexID(), 123), 456);
        int byteBufLen = ExecutionAttemptID.getByteBufLength();
        ByteBuf byteBuf = ALLOCATOR.directBuffer(byteBufLen, byteBufLen);
        executionAttemptID.writeTo(byteBuf);
        Assert.assertThat((Object)byteBuf.writerIndex(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ExecutionAttemptID.getByteBufLength())));
        Assert.assertThat((Object)ExecutionAttemptID.fromByteBuf((ByteBuf)byteBuf), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)executionAttemptID)));
    }
}

