/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.runtime.checkpoint.MappingBasedRepartitioner;
import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.junit.Assert;
import org.junit.Test;

public class MappingBasedRepartitionerTest {
    @Test
    public void testBroadcastRedistributeOnScaleDown() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assert.assertEquals(Arrays.asList(Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1")), this.repartition(oldStates, SubtaskStateMapper.FULL, 3, 2));
    }

    @Test
    public void testBroadcastRedistributeOnNoScale() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assert.assertEquals(Arrays.asList(Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1")), this.repartition(oldStates, SubtaskStateMapper.FULL, 3, 3));
    }

    @Test
    public void testBroadcastRedistributeOnScaleUp() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assert.assertEquals(Arrays.asList(Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1")), this.repartition(oldStates, SubtaskStateMapper.FULL, 3, 4));
    }

    @Test
    public void testRangeSelectorRedistributeOnScaleDown() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assert.assertEquals(Arrays.asList(Arrays.asList("sub0state0", "sub0state1", "sub1state0"), Arrays.asList("sub1state0", "sub2state0", "sub2state1")), this.repartition(oldStates, SubtaskStateMapper.RANGE, 3, 2));
    }

    @Test
    public void testRangeSelectorRedistributeOnNoScale() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assert.assertEquals(Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1")), this.repartition(oldStates, SubtaskStateMapper.RANGE, 3, 3));
    }

    @Test
    public void testRangeSelectorRedistributeOnScaleUp() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assert.assertEquals(Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0"), Arrays.asList("sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub2state0", "sub2state1")), this.repartition(oldStates, SubtaskStateMapper.RANGE, 3, 4));
    }

    @Test
    public void testRoundRobinRedistributeOnScaleDown() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assert.assertEquals(Arrays.asList(Arrays.asList("sub0state0", "sub0state1", "sub2state0", "sub2state1"), Arrays.asList("sub1state0")), this.repartition(oldStates, SubtaskStateMapper.ROUND_ROBIN, 3, 2));
        Assert.assertEquals(Arrays.asList(Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1")), this.repartition(oldStates, SubtaskStateMapper.ROUND_ROBIN, 3, 1));
    }

    @Test
    public void testRoundRobinRedistributeOnNoScale() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assert.assertEquals(Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1")), this.repartition(oldStates, SubtaskStateMapper.ROUND_ROBIN, 3, 3));
    }

    @Test
    public void testRoundRobinRedistributeOnScaleUp() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assert.assertEquals(Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"), Arrays.asList(new Object[0])), this.repartition(oldStates, SubtaskStateMapper.ROUND_ROBIN, 3, 4));
        Assert.assertEquals(Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"), Arrays.asList(new Object[0]), Arrays.asList(new Object[0])), this.repartition(oldStates, SubtaskStateMapper.ROUND_ROBIN, 3, 5));
    }

    private List<List<String>> repartition(List<List<String>> oldStates, SubtaskStateMapper mapper, int oldParalellism, int newParallelism) {
        return new MappingBasedRepartitioner(mapper.getNewToOldSubtasksMapping(oldParalellism, newParallelism)).repartitionState(oldStates, oldParalellism, newParallelism);
    }
}

