/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummary;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummarySnapshot;
import org.apache.flink.runtime.checkpoint.StatsSummary;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CompletedCheckpointStatsSummaryTest {
    @Test
    void testSimpleUpdates() {
        long triggerTimestamp = 123123L;
        long ackTimestamp = 1212435522L;
        long stateSize = 2147501434L;
        long processedData = 2147606770L;
        long persistedData = 2147483689L;
        boolean unalignedCheckpoint = true;
        CompletedCheckpointStatsSummary summary = new CompletedCheckpointStatsSummary();
        Assertions.assertThat((long)summary.getStateSizeStats().getCount()).isZero();
        Assertions.assertThat((long)summary.getEndToEndDurationStats().getCount()).isZero();
        Assertions.assertThat((long)summary.getProcessedDataStats().getCount()).isZero();
        Assertions.assertThat((long)summary.getPersistedDataStats().getCount()).isZero();
        int numCheckpoints = 10;
        for (int i = 0; i < numCheckpoints; ++i) {
            CompletedCheckpointStats completed = this.createCompletedCheckpoint(i, triggerTimestamp, ackTimestamp + (long)i, stateSize + (long)i, processedData + (long)i, persistedData + (long)i, unalignedCheckpoint);
            summary.updateSummary(completed);
            Assertions.assertThat((long)summary.getStateSizeStats().getCount()).isEqualTo((long)(i + 1));
            Assertions.assertThat((long)summary.getEndToEndDurationStats().getCount()).isEqualTo((long)(i + 1));
            Assertions.assertThat((long)summary.getProcessedDataStats().getCount()).isEqualTo((long)(i + 1));
            Assertions.assertThat((long)summary.getPersistedDataStats().getCount()).isEqualTo((long)(i + 1));
        }
        StatsSummary stateSizeStats = summary.getStateSizeStats();
        Assertions.assertThat((long)stateSizeStats.getMinimum()).isEqualTo(stateSize);
        Assertions.assertThat((long)stateSizeStats.getMaximum()).isEqualTo(stateSize + (long)numCheckpoints - 1L);
        StatsSummary durationStats = summary.getEndToEndDurationStats();
        Assertions.assertThat((long)durationStats.getMinimum()).isEqualTo(ackTimestamp - triggerTimestamp);
        Assertions.assertThat((long)durationStats.getMaximum()).isEqualTo(ackTimestamp - triggerTimestamp + (long)numCheckpoints - 1L);
        StatsSummary processedDataStats = summary.getProcessedDataStats();
        Assertions.assertThat((long)processedDataStats.getMinimum()).isEqualTo(processedData);
        Assertions.assertThat((long)processedDataStats.getMaximum()).isEqualTo(processedData + (long)numCheckpoints - 1L);
        StatsSummary persistedDataStats = summary.getPersistedDataStats();
        Assertions.assertThat((long)persistedDataStats.getMinimum()).isEqualTo(persistedData);
        Assertions.assertThat((long)persistedDataStats.getMaximum()).isEqualTo(persistedData + (long)numCheckpoints - 1L);
    }

    private CompletedCheckpointStats createCompletedCheckpoint(long checkpointId, long triggerTimestamp, long ackTimestamp, long stateSize, long processedData, long persistedData, boolean unalignedCheckpoint) {
        SubtaskStateStats latest = (SubtaskStateStats)Mockito.mock(SubtaskStateStats.class);
        Mockito.when((Object)latest.getAckTimestamp()).thenReturn((Object)ackTimestamp);
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        JobVertexID jobVertexId = new JobVertexID();
        taskStats.put(jobVertexId, new TaskStateStats(jobVertexId, 1));
        return new CompletedCheckpointStats(checkpointId, triggerTimestamp, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1, taskStats, 1, stateSize, processedData, persistedData, unalignedCheckpoint, latest, null);
    }

    @Test
    void testQuantiles() {
        int stateSize = 100;
        int processedData = 200;
        int persistedData = 300;
        boolean unalignedCheckpoint = true;
        long triggerTimestamp = 1234L;
        long lastAck = triggerTimestamp + 123L;
        CompletedCheckpointStatsSummary summary = new CompletedCheckpointStatsSummary();
        summary.updateSummary(new CompletedCheckpointStats(1L, triggerTimestamp, CheckpointProperties.forSavepoint((boolean)false, (SavepointFormatType)SavepointFormatType.CANONICAL), 1, Collections.singletonMap(new JobVertexID(), new TaskStateStats(new JobVertexID(), 1)), 1, (long)stateSize, (long)processedData, (long)persistedData, unalignedCheckpoint, new SubtaskStateStats(0, lastAck), ""));
        CompletedCheckpointStatsSummarySnapshot snapshot = summary.createSnapshot();
        Assertions.assertThat((double)snapshot.getStateSizeStats().getQuantile(1.0)).isCloseTo((double)stateSize, Offset.offset((Number)0.0));
        Assertions.assertThat((double)snapshot.getProcessedDataStats().getQuantile(1.0)).isCloseTo((double)processedData, Offset.offset((Number)0.0));
        Assertions.assertThat((double)snapshot.getPersistedDataStats().getQuantile(1.0)).isCloseTo((double)persistedData, Offset.offset((Number)0.0));
        Assertions.assertThat((double)snapshot.getEndToEndDurationStats().getQuantile(1.0)).isCloseTo((double)(lastAck - triggerTimestamp), Offset.offset((Number)0.0));
    }
}

