/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStoreTest;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryImpl;
import org.apache.flink.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointsCleanerTest {
    @Test
    public void testNotCleanCheckpointInUse() {
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl();
        CheckpointsCleaner checkpointsCleaner = new CheckpointsCleaner();
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp1 = CompletedCheckpointStoreTest.createCheckpoint(1L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp1);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp2 = CompletedCheckpointStoreTest.createCheckpoint(2L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp2);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp3 = CompletedCheckpointStoreTest.createCheckpoint(3L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp3);
        checkpointsCleaner.cleanSubsumedCheckpoints(3L, Collections.singleton(1L), () -> {}, Executors.directExecutor());
        Assert.assertFalse((boolean)cp1.isDiscarded());
        Assert.assertTrue((boolean)cp2.isDiscarded());
    }

    @Test
    public void testNotCleanHigherCheckpoint() {
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl();
        CheckpointsCleaner checkpointsCleaner = new CheckpointsCleaner();
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp1 = CompletedCheckpointStoreTest.createCheckpoint(1L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp1);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp2 = CompletedCheckpointStoreTest.createCheckpoint(2L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp2);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp3 = CompletedCheckpointStoreTest.createCheckpoint(3L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp3);
        checkpointsCleaner.cleanSubsumedCheckpoints(2L, Collections.emptySet(), () -> {}, Executors.directExecutor());
        Assert.assertTrue((boolean)cp1.isDiscarded());
        Assert.assertFalse((boolean)cp2.isDiscarded());
        Assert.assertFalse((boolean)cp3.isDiscarded());
    }
}

