/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CheckpointMetricsBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CheckpointMetricsTest {
    @Test
    public void testUnalignedCheckpointType() throws Exception {
        CheckpointMetricsBuilder metricsBuilder = new CheckpointMetricsBuilder();
        metricsBuilder.setBytesProcessedDuringAlignment(0L);
        metricsBuilder.setAlignmentDurationNanos(0L);
        metricsBuilder.setBytesPersistedOfThisCheckpoint(0L);
        metricsBuilder.setTotalBytesPersisted(0L);
        Assertions.assertThat((boolean)metricsBuilder.build().getUnalignedCheckpoint()).isFalse();
        Assertions.assertThat((boolean)metricsBuilder.buildIncomplete().getUnalignedCheckpoint()).isFalse();
        this.assertUnalignedCheckpointType(metricsBuilder, 0L);
        this.assertUnalignedCheckpointType(metricsBuilder, 1L);
        this.assertUnalignedCheckpointType(metricsBuilder, 5L);
        this.assertUnalignedCheckpointType(metricsBuilder, 10L);
        this.assertUnalignedCheckpointType(metricsBuilder, 100L);
    }

    private void assertUnalignedCheckpointType(CheckpointMetricsBuilder metricsBuilder, long bytesPersistedDuringAlignment) {
        boolean expectedUnalignedCheckpointType = bytesPersistedDuringAlignment > 0L;
        metricsBuilder.setBytesPersistedDuringAlignment(bytesPersistedDuringAlignment);
        Assertions.assertThat((boolean)metricsBuilder.build().getUnalignedCheckpoint()).isEqualTo(expectedUnalignedCheckpointType);
        Assertions.assertThat((boolean)metricsBuilder.buildIncomplete().getUnalignedCheckpoint()).isEqualTo(expectedUnalignedCheckpointType);
    }
}

