/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.View;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class TimerGauge
implements Gauge<Long>,
View {
    private final Clock clock;
    private long previousCount;
    private long currentCount;
    private long currentMeasurementStartTS;
    private long currentUpdateTS;
    private long previousMaxSingleMeasurement;
    private long currentMaxSingleMeasurement;
    private long accumulatedCount;

    public TimerGauge() {
        this((Clock)SystemClock.getInstance());
    }

    public TimerGauge(Clock clock) {
        this.clock = clock;
    }

    public synchronized void markStart() {
        if (this.currentMeasurementStartTS == 0L) {
            this.currentMeasurementStartTS = this.currentUpdateTS = this.clock.absoluteTimeMillis();
        }
    }

    public synchronized void markEnd() {
        if (this.currentMeasurementStartTS != 0L) {
            long currentMeasurement = this.clock.absoluteTimeMillis() - this.currentMeasurementStartTS;
            this.currentCount += currentMeasurement;
            this.accumulatedCount += currentMeasurement;
            this.currentMaxSingleMeasurement = Math.max(this.currentMaxSingleMeasurement, currentMeasurement);
            this.currentUpdateTS = 0L;
            this.currentMeasurementStartTS = 0L;
        }
    }

    public synchronized void update() {
        if (this.currentMeasurementStartTS != 0L) {
            long now = this.clock.absoluteTimeMillis();
            this.currentCount += now - this.currentUpdateTS;
            this.accumulatedCount += now - this.currentUpdateTS;
            this.currentUpdateTS = now;
            this.currentMaxSingleMeasurement = Math.max(this.currentMaxSingleMeasurement, now - this.currentMeasurementStartTS);
        }
        this.previousCount = Math.max(Math.min(this.currentCount / 5L, 1000L), 0L);
        this.previousMaxSingleMeasurement = this.currentMaxSingleMeasurement;
        this.currentCount = 0L;
        this.currentMaxSingleMeasurement = 0L;
    }

    public synchronized Long getValue() {
        return this.previousCount;
    }

    public synchronized long getMaxSingleMeasurement() {
        return this.previousMaxSingleMeasurement;
    }

    public synchronized long getAccumulatedCount() {
        return this.accumulatedCount;
    }

    @VisibleForTesting
    public synchronized long getCount() {
        return this.currentCount;
    }

    @VisibleForTesting
    public synchronized boolean isMeasuring() {
        return this.currentMeasurementStartTS != 0L;
    }
}

