/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.testutils.recordutils.RecordComparator;
import org.apache.flink.runtime.testutils.recordutils.RecordSerializer;
import org.apache.flink.runtime.util.ReusingKeyGroupedIterator;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.TraversableOnceException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReusingKeyGroupedIteratorTest {
    private MutableObjectIterator<Record> sourceIter;
    private ReusingKeyGroupedIterator<Record> psi;

    @Before
    public void setup() {
        final ArrayList<IntStringPair> source = new ArrayList<IntStringPair>();
        source.add(new IntStringPair(new IntValue(1), new StringValue((CharSequence)"A")));
        source.add(new IntStringPair(new IntValue(2), new StringValue((CharSequence)"B")));
        source.add(new IntStringPair(new IntValue(3), new StringValue((CharSequence)"C")));
        source.add(new IntStringPair(new IntValue(3), new StringValue((CharSequence)"D")));
        source.add(new IntStringPair(new IntValue(4), new StringValue((CharSequence)"E")));
        source.add(new IntStringPair(new IntValue(4), new StringValue((CharSequence)"F")));
        source.add(new IntStringPair(new IntValue(4), new StringValue((CharSequence)"G")));
        source.add(new IntStringPair(new IntValue(5), new StringValue((CharSequence)"H")));
        source.add(new IntStringPair(new IntValue(5), new StringValue((CharSequence)"I")));
        source.add(new IntStringPair(new IntValue(5), new StringValue((CharSequence)"J")));
        source.add(new IntStringPair(new IntValue(5), new StringValue((CharSequence)"K")));
        source.add(new IntStringPair(new IntValue(5), new StringValue((CharSequence)"L")));
        this.sourceIter = new MutableObjectIterator<Record>(){
            final Iterator<IntStringPair> it;
            {
                this.it = source.iterator();
            }

            public Record next(Record reuse) throws IOException {
                if (this.it.hasNext()) {
                    IntStringPair pair = this.it.next();
                    reuse.setField(0, (Value)pair.getInteger());
                    reuse.setField(1, (Value)pair.getString());
                    return reuse;
                }
                return null;
            }

            public Record next() throws IOException {
                if (this.it.hasNext()) {
                    IntStringPair pair = this.it.next();
                    Record result = new Record(2);
                    result.setField(0, (Value)pair.getInteger());
                    result.setField(1, (Value)pair.getString());
                    return result;
                }
                return null;
            }
        };
        RecordSerializer serializer = RecordSerializer.get();
        RecordComparator comparator = new RecordComparator(new int[]{0}, new Class[]{IntValue.class});
        this.psi = new ReusingKeyGroupedIterator(this.sourceIter, (TypeSerializer)serializer, (TypeComparator)comparator);
    }

    @Test
    public void testNextKeyOnly() throws Exception {
        try {
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(1))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)1L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(2))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)2L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)4L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)5L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertFalse((String)"KeyGroupedIterator must not have another key.", (boolean)this.psi.nextKey());
            Assert.assertNull((String)"KeyGroupedIterator must not have another value.", (Object)this.psi.getValues());
            Assert.assertFalse((String)"KeyGroupedIterator must not have another key.", (boolean)this.psi.nextKey());
            Assert.assertFalse((String)"KeyGroupedIterator must not have another key.", (boolean)this.psi.nextKey());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"The test encountered an unexpected exception.");
        }
    }

    @Test
    public void testFullIterationThroughAllValues() throws IOException {
        try {
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertFalse((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(1))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)1L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"A"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertFalse((String)"KeyGroupedIterator must not have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertFalse((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(2))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)2L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"B"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertFalse((String)"KeyGroupedIterator must not have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertFalse((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"C"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"D"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            try {
                this.psi.getValues().next();
                Assert.fail((String)"A new KeyGroupedIterator must not have any value available and hence throw an exception on next().");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            Assert.assertFalse((String)"KeyGroupedIterator must not have another value.", (boolean)this.psi.getValues().hasNext());
            try {
                this.psi.getValues().next();
                Assert.fail((String)"A new KeyGroupedIterator must not have any value available and hence throw an exception on next().");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertFalse((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)4L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"E"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)4L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"F"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)4L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"G"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)4L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertFalse((String)"KeyGroupedIterator must not have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)4L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertFalse((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)5L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"H"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)5L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"I"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)5L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"J"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)5L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"K"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)5L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"L"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)5L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            try {
                this.psi.getValues().next();
                Assert.fail((String)"A new KeyGroupedIterator must not have any value available and hence throw an exception on next().");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            Assert.assertFalse((String)"KeyGroupedIterator must not have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)5L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            try {
                this.psi.getValues().next();
                Assert.fail((String)"A new KeyGroupedIterator must not have any value available and hence throw an exception on next().");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            Assert.assertFalse((String)"KeyGroupedIterator must not have another key.", (boolean)this.psi.nextKey());
            Assert.assertFalse((String)"KeyGroupedIterator must not have another key.", (boolean)this.psi.nextKey());
            Assert.assertNull((Object)this.psi.getValues());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"The test encountered an unexpected exception.");
        }
    }

    @Test
    public void testMixedProgress() throws Exception {
        try {
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertFalse((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertFalse((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertFalse((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"C"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertTrue((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertFalse((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"E"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"H"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator returned a wrong key.", (boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5))));
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)5L, (long)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"I"), (Object)((Record)this.psi.getValues().next()).getField(1, StringValue.class));
            Assert.assertTrue((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertFalse((boolean)this.hasIterator((Iterable<?>)this.psi.getValues()));
            Assert.assertTrue((String)"KeyGroupedIterator must have another value.", (boolean)this.psi.getValues().hasNext());
            Assert.assertFalse((String)"KeyGroupedIterator must not have another key.", (boolean)this.psi.nextKey());
            Assert.assertFalse((String)"KeyGroupedIterator must not have another key.", (boolean)this.psi.nextKey());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"The test encountered an unexpected exception.");
        }
    }

    @Test
    public void testHasNextDoesNotOverweiteCurrentRecord() throws Exception {
        try {
            ReusingKeyGroupedIterator.ValuesIterator valsIter = null;
            Record rec = null;
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            valsIter = this.psi.getValues();
            Assert.assertNotNull((String)"Returned Iterator must not be null", (Object)valsIter);
            Assert.assertTrue((String)"KeyGroupedIterator's value iterator must have another value.", (boolean)valsIter.hasNext());
            rec = (Record)valsIter.next();
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)1L, (long)((IntValue)rec.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"A"), (Object)rec.getField(1, StringValue.class));
            Assert.assertFalse((String)"KeyGroupedIterator must have another value.", (boolean)valsIter.hasNext());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)1L, (long)((IntValue)rec.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"A"), (Object)rec.getField(1, StringValue.class));
            Assert.assertFalse((String)"KeyGroupedIterator's value iterator must not have another value.", (boolean)valsIter.hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            valsIter = this.psi.getValues();
            Assert.assertNotNull((String)"Returned Iterator must not be null", (Object)valsIter);
            Assert.assertTrue((String)"KeyGroupedIterator's value iterator must have another value.", (boolean)valsIter.hasNext());
            rec = (Record)valsIter.next();
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)2L, (long)((IntValue)rec.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"B"), (Object)rec.getField(1, StringValue.class));
            Assert.assertFalse((String)"KeyGroupedIterator must have another value.", (boolean)valsIter.hasNext());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)2L, (long)((IntValue)rec.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"B"), (Object)rec.getField(1, StringValue.class));
            Assert.assertFalse((String)"KeyGroupedIterator's value iterator must not have another value.", (boolean)valsIter.hasNext());
            Assert.assertTrue((String)"KeyGroupedIterator must have another key.", (boolean)this.psi.nextKey());
            valsIter = this.psi.getValues();
            Assert.assertNotNull((String)"Returned Iterator must not be null", (Object)valsIter);
            Assert.assertTrue((String)"KeyGroupedIterator's value iterator must have another value.", (boolean)valsIter.hasNext());
            rec = (Record)valsIter.next();
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)rec.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"C"), (Object)rec.getField(1, StringValue.class));
            Assert.assertTrue((String)"KeyGroupedIterator's value iterator must have another value.", (boolean)valsIter.hasNext());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)rec.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"C"), (Object)rec.getField(1, StringValue.class));
            rec = (Record)valsIter.next();
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)rec.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"D"), (Object)rec.getField(1, StringValue.class));
            Assert.assertFalse((String)"KeyGroupedIterator's value iterator must have another value.", (boolean)valsIter.hasNext());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)rec.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"D"), (Object)rec.getField(1, StringValue.class));
            Assert.assertFalse((String)"KeyGroupedIterator's value iterator must have another value.", (boolean)valsIter.hasNext());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong key.", (long)3L, (long)((IntValue)rec.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((String)"KeyGroupedIterator returned a wrong value.", (Object)new StringValue((CharSequence)"D"), (Object)rec.getField(1, StringValue.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"The test encountered an unexpected exception.");
        }
    }

    public boolean hasIterator(Iterable<?> iterable) {
        try {
            iterable.iterator();
            return true;
        }
        catch (TraversableOnceException e) {
            return false;
        }
    }

    private static final class IntStringPair {
        private final IntValue integer;
        private final StringValue string;

        IntStringPair(IntValue integer, StringValue string) {
            this.integer = integer;
            this.string = string;
        }

        public IntValue getInteger() {
            return this.integer;
        }

        public StringValue getString() {
            return this.string;
        }
    }
}

