/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.security.token.KerberosLoginProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class KerberosLoginProviderITCase {
    @Test
    public void isLoginPossibleMustReturnFalseByDefault() throws IOException {
        Configuration configuration = new Configuration();
        KerberosLoginProvider kerberosLoginProvider = new KerberosLoginProvider(configuration);
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            ugi.when(UserGroupInformation::getCurrentUser).thenReturn((Object)userGroupInformation);
            Assertions.assertFalse((boolean)kerberosLoginProvider.isLoginPossible());
        }
    }

    @Test
    public void isLoginPossibleMustReturnTrueWithKeytab(@TempDir Path tmpDir) throws IOException {
        Configuration configuration = new Configuration();
        configuration.setString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, "principal");
        Path keyTab = Files.createFile(tmpDir.resolve("test.keytab"), new FileAttribute[0]);
        configuration.setString(SecurityOptions.KERBEROS_LOGIN_KEYTAB, keyTab.toAbsolutePath().toString());
        KerberosLoginProvider kerberosLoginProvider = new KerberosLoginProvider(configuration);
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            ugi.when(UserGroupInformation::getCurrentUser).thenReturn((Object)userGroupInformation);
            Assertions.assertTrue((boolean)kerberosLoginProvider.isLoginPossible());
        }
    }

    @Test
    public void isLoginPossibleMustReturnTrueWithTGT() throws IOException {
        Configuration configuration = new Configuration();
        configuration.setBoolean(SecurityOptions.KERBEROS_LOGIN_USETICKETCACHE, true);
        KerberosLoginProvider kerberosLoginProvider = new KerberosLoginProvider(configuration);
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            Mockito.when((Object)userGroupInformation.getAuthenticationMethod()).thenReturn((Object)UserGroupInformation.AuthenticationMethod.KERBEROS);
            Mockito.when((Object)userGroupInformation.hasKerberosCredentials()).thenReturn((Object)true);
            ugi.when(UserGroupInformation::getCurrentUser).thenReturn((Object)userGroupInformation);
            Assertions.assertTrue((boolean)kerberosLoginProvider.isLoginPossible());
        }
    }

    @Test
    public void isLoginPossibleMustThrowExceptionWithProxyUser() {
        Configuration configuration = new Configuration();
        KerberosLoginProvider kerberosLoginProvider = new KerberosLoginProvider(configuration);
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            Mockito.when((Object)userGroupInformation.getAuthenticationMethod()).thenReturn((Object)UserGroupInformation.AuthenticationMethod.PROXY);
            ugi.when(UserGroupInformation::getCurrentUser).thenReturn((Object)userGroupInformation);
            Assertions.assertThrows(UnsupportedOperationException.class, () -> ((KerberosLoginProvider)kerberosLoginProvider).isLoginPossible());
        }
    }

    @Test
    public void doLoginMustLoginWithKeytab(@TempDir Path tmpDir) throws IOException {
        Configuration configuration = new Configuration();
        configuration.setString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, "principal");
        Path keyTab = Files.createFile(tmpDir.resolve("test.keytab"), new FileAttribute[0]);
        configuration.setString(SecurityOptions.KERBEROS_LOGIN_KEYTAB, keyTab.toAbsolutePath().toString());
        KerberosLoginProvider kerberosLoginProvider = new KerberosLoginProvider(configuration);
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            ugi.when(UserGroupInformation::getCurrentUser).thenReturn((Object)userGroupInformation);
            kerberosLoginProvider.doLogin();
            ugi.verify(() -> UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString()));
        }
    }

    @Test
    public void doLoginMustLoginWithTGT() throws IOException {
        Configuration configuration = new Configuration();
        configuration.setBoolean(SecurityOptions.KERBEROS_LOGIN_USETICKETCACHE, true);
        KerberosLoginProvider kerberosLoginProvider = new KerberosLoginProvider(configuration);
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            Mockito.when((Object)userGroupInformation.getAuthenticationMethod()).thenReturn((Object)UserGroupInformation.AuthenticationMethod.KERBEROS);
            Mockito.when((Object)userGroupInformation.hasKerberosCredentials()).thenReturn((Object)true);
            ugi.when(UserGroupInformation::getCurrentUser).thenReturn((Object)userGroupInformation);
            kerberosLoginProvider.doLogin();
            ugi.verify(() -> UserGroupInformation.getUGIFromTicketCache(null, null));
        }
    }

    @Test
    public void doLoginMustThrowExceptionWithProxyUser() {
        Configuration configuration = new Configuration();
        KerberosLoginProvider kerberosLoginProvider = new KerberosLoginProvider(configuration);
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            Mockito.when((Object)userGroupInformation.getAuthenticationMethod()).thenReturn((Object)UserGroupInformation.AuthenticationMethod.PROXY);
            ugi.when(UserGroupInformation::getCurrentUser).thenReturn((Object)userGroupInformation);
            Assertions.assertThrows(UnsupportedOperationException.class, () -> ((KerberosLoginProvider)kerberosLoginProvider).doLogin());
        }
    }
}

