/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Objects;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class ArchivedTaskManagerLocationMatcher
extends TypeSafeDiagnosingMatcher<ExceptionHistoryEntry.ArchivedTaskManagerLocation> {
    private final ExceptionHistoryEntry.ArchivedTaskManagerLocation expectedLocation;

    public static Matcher<ExceptionHistoryEntry.ArchivedTaskManagerLocation> isArchivedTaskManagerLocation(TaskManagerLocation actualLocation) {
        return new ArchivedTaskManagerLocationMatcher(actualLocation);
    }

    ArchivedTaskManagerLocationMatcher(TaskManagerLocation expectedLocation) {
        this(ExceptionHistoryEntry.ArchivedTaskManagerLocation.fromTaskManagerLocation((TaskManagerLocation)expectedLocation));
    }

    ArchivedTaskManagerLocationMatcher(ExceptionHistoryEntry.ArchivedTaskManagerLocation expectedLocation) {
        this.expectedLocation = expectedLocation;
    }

    protected boolean matchesSafely(ExceptionHistoryEntry.ArchivedTaskManagerLocation actual, Description description) {
        if (actual == null) {
            return this.expectedLocation == null;
        }
        if (this.expectedLocation == null) {
            return false;
        }
        boolean match = true;
        if (!Objects.equals(actual.getAddress(), this.expectedLocation.getAddress())) {
            description.appendText(" address=").appendText(actual.getAddress());
            match = false;
        }
        if (!Objects.equals(actual.getFQDNHostname(), this.expectedLocation.getFQDNHostname())) {
            description.appendText(" FQDNHostname=").appendText(actual.getFQDNHostname());
            match = false;
        }
        if (!Objects.equals(actual.getHostname(), this.expectedLocation.getHostname())) {
            description.appendText(" hostname=").appendText(actual.getHostname());
            match = false;
        }
        if (!Objects.equals(actual.getResourceID(), this.expectedLocation.getResourceID())) {
            description.appendText(" resourceID=").appendText(actual.getResourceID().toString());
            match = false;
        }
        if (!Objects.equals(actual.getPort(), this.expectedLocation.getPort())) {
            description.appendText(" port=").appendText(String.valueOf(actual.getPort()));
            match = false;
        }
        return match;
    }

    public void describeTo(Description description) {
        description.appendText(String.valueOf(this.expectedLocation));
    }
}

