/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.TestingPluginManager;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.reporter.InstantiateViaFactory;
import org.apache.flink.metrics.reporter.InterceptInstantiationViaReflection;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.apache.flink.testutils.junit.extensions.ContextClassLoaderExtension;
import org.apache.flink.util.TestLoggerExtension;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;

@ExtendWith(value={TestLoggerExtension.class})
class ReporterSetupTest {
    @RegisterExtension
    static final ContextClassLoaderExtension CONTEXT_CLASS_LOADER_EXTENSION = ContextClassLoaderExtension.builder().withServiceEntry(MetricReporterFactory.class, new String[]{TestReporter1.class.getName(), TestReporter2.class.getName(), TestReporter11.class.getName(), TestReporter12.class.getName(), TestReporter13.class.getName(), TestReporterFactory.class.getName(), FailingFactory.class.getName(), InstantiationTypeTrackingTestReporterFactory.class.getName(), ConfigExposingReporterFactory.class.getName()}).build();

    ReporterSetupTest() {
    }

    @Test
    void testReporterArgumentForwarding() {
        Configuration config = new Configuration();
        ReporterSetupTest.configureReporter1(config);
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        ReporterSetupTest.assertReporter1Configured(reporterSetup);
    }

    @Test
    void testSeveralReportersWithArgumentForwarding() {
        Configuration config = new Configuration();
        ReporterSetupTest.configureReporter1(config);
        ReporterSetupTest.configureReporter2(config);
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)2L, (long)reporterSetups.size());
        Optional<ReporterSetup> reporter1Config = reporterSetups.stream().filter(c -> "reporter1".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)reporter1Config.isPresent());
        ReporterSetupTest.assertReporter1Configured(reporter1Config.get());
        Optional<ReporterSetup> reporter2Config = reporterSetups.stream().filter(c -> "reporter2".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)reporter2Config.isPresent());
        ReporterSetupTest.assertReporter2Configured(reporter2Config.get());
    }

    @Test
    void testActivateOneReporterAmongTwoDeclared() {
        Configuration config = new Configuration();
        ReporterSetupTest.configureReporter1(config);
        ReporterSetupTest.configureReporter2(config);
        config.setString(MetricOptions.REPORTERS_LIST, "reporter2");
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup setup = (ReporterSetup)reporterSetups.get(0);
        ReporterSetupTest.assertReporter2Configured(setup);
    }

    @Test
    void testReporterSetupSupplier() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.reporter1." + MetricOptions.REPORTER_FACTORY_CLASS.key(), TestReporter1.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        MetricReporter metricReporter = reporterSetup.getReporter();
        Assert.assertThat((Object)metricReporter, (Matcher)IsInstanceOf.instanceOf(TestReporter1.class));
    }

    @Test
    void testMultipleReporterInstantiation() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test1." + MetricOptions.REPORTER_FACTORY_CLASS.key(), TestReporter11.class.getName());
        config.setString("metrics.reporter.test2." + MetricOptions.REPORTER_FACTORY_CLASS.key(), TestReporter12.class.getName());
        config.setString("metrics.reporter.test3." + MetricOptions.REPORTER_FACTORY_CLASS.key(), TestReporter13.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)3L, (long)reporterSetups.size());
        Assert.assertTrue((boolean)TestReporter11.wasOpened);
        Assert.assertTrue((boolean)TestReporter12.wasOpened);
        Assert.assertTrue((boolean)TestReporter13.wasOpened);
    }

    private static void configureReporter1(Configuration config) {
        config.setString("metrics.reporter.reporter1." + MetricOptions.REPORTER_FACTORY_CLASS.key(), TestReporter1.class.getName());
        config.setString("metrics.reporter.reporter1.arg1", "value1");
        config.setString("metrics.reporter.reporter1.arg2", "value2");
    }

    private static void assertReporter1Configured(ReporterSetup setup) {
        Assert.assertEquals((Object)"reporter1", (Object)setup.getName());
        Assert.assertEquals((Object)"value1", (Object)setup.getConfiguration().getString("arg1", ""));
        Assert.assertEquals((Object)"value2", (Object)setup.getConfiguration().getString("arg2", ""));
        Assert.assertEquals((Object)TestReporter1.class.getName(), (Object)setup.getConfiguration().getString(MetricOptions.REPORTER_FACTORY_CLASS.key(), null));
    }

    private static void configureReporter2(Configuration config) {
        config.setString("metrics.reporter.reporter2." + MetricOptions.REPORTER_FACTORY_CLASS.key(), TestReporter2.class.getName());
        config.setString("metrics.reporter.reporter2.arg1", "value1");
        config.setString("metrics.reporter.reporter2.arg3", "value3");
    }

    private static void assertReporter2Configured(ReporterSetup setup) {
        Assert.assertEquals((Object)"reporter2", (Object)setup.getName());
        Assert.assertEquals((Object)"value1", (Object)setup.getConfiguration().getString("arg1", null));
        Assert.assertEquals((Object)"value3", (Object)setup.getConfiguration().getString("arg3", null));
        Assert.assertEquals((Object)TestReporter2.class.getName(), (Object)setup.getConfiguration().getString(MetricOptions.REPORTER_FACTORY_CLASS.key(), null));
    }

    @Test
    void testVariableExclusionParsing() throws Exception {
        String excludedVariable1 = "foo";
        String excludedVariable2 = "foo";
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test." + MetricOptions.REPORTER_FACTORY_CLASS.key(), TestReporterFactory.class.getName());
        config.setString("metrics.reporter.test." + MetricOptions.REPORTER_EXCLUDED_VARIABLES.key(), "foo;foo");
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        MatcherAssert.assertThat((Object)reporterSetup.getExcludedVariables(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{ScopeFormat.asVariable((String)"foo"), ScopeFormat.asVariable((String)"foo")}));
    }

    @Test
    void testFactoryParsing() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test." + MetricOptions.REPORTER_FACTORY_CLASS.key(), TestReporterFactory.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        Assert.assertEquals((Object)TestReporterFactory.REPORTER, (Object)reporterSetup.getReporter());
    }

    @Test
    public void testFactoryPrioritization() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test." + MetricOptions.REPORTER_FACTORY_CLASS.key(), InstantiationTypeTrackingTestReporterFactory.class.getName());
        config.setString("metrics.reporter.test." + MetricOptions.REPORTER_CLASS.key(), InstantiationTypeTrackingTestReporter.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        InstantiationTypeTrackingTestReporter metricReporter = (InstantiationTypeTrackingTestReporter)reporterSetup.getReporter();
        Assert.assertTrue((boolean)metricReporter.createdByFactory);
    }

    @Test
    void testFactoryFailureIsolation() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test." + MetricOptions.REPORTER_FACTORY_CLASS.key(), TestReporterFactory.class.getName());
        config.setString("metrics.reporter.fail." + MetricOptions.REPORTER_FACTORY_CLASS.key(), FailingFactory.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
    }

    @Test
    public void testMixedSetupsFactoryParsing() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test1." + MetricOptions.REPORTER_FACTORY_CLASS.key(), InstantiationTypeTrackingTestReporterFactory.class.getName());
        config.setString("metrics.reporter.test2." + MetricOptions.REPORTER_CLASS.key(), InstantiationTypeTrackingTestReporter.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)2L, (long)reporterSetups.size());
        ReporterSetup reporterSetup1 = (ReporterSetup)reporterSetups.get(0);
        ReporterSetup reporterSetup2 = (ReporterSetup)reporterSetups.get(1);
        InstantiationTypeTrackingTestReporter metricReporter1 = (InstantiationTypeTrackingTestReporter)reporterSetup1.getReporter();
        InstantiationTypeTrackingTestReporter metricReporter2 = (InstantiationTypeTrackingTestReporter)reporterSetup2.getReporter();
        Assert.assertTrue((boolean)(metricReporter1.createdByFactory ^ metricReporter2.createdByFactory));
    }

    @Test
    void testFactoryArgumentForwarding() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test." + MetricOptions.REPORTER_FACTORY_CLASS.key(), ConfigExposingReporterFactory.class.getName());
        config.setString("metrics.reporter.test.arg", "hello");
        ReporterSetup.fromConfiguration((Configuration)config, null);
        Properties passedConfig = ConfigExposingReporterFactory.lastConfig;
        Assert.assertEquals((Object)"hello", (Object)passedConfig.getProperty("arg"));
    }

    @Test
    public void testFactoryAnnotation() {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test." + MetricOptions.REPORTER_CLASS.key(), InstantiationTypeTrackingTestReporter2.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        InstantiationTypeTrackingTestReporter metricReporter = (InstantiationTypeTrackingTestReporter)reporterSetup.getReporter();
        Assert.assertTrue((boolean)metricReporter.createdByFactory);
    }

    @Test
    public void testReflectionInterception() {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test." + MetricOptions.REPORTER_CLASS.key(), InstantiationTypeTrackingTestReporter.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, (PluginManager)new TestingPluginManager(Collections.singletonMap(MetricReporterFactory.class, Collections.singletonList(new InterceptingInstantiationTypeTrackingTestReporterFactory()).iterator())));
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        InstantiationTypeTrackingTestReporter metricReporter = (InstantiationTypeTrackingTestReporter)reporterSetup.getReporter();
        Assert.assertTrue((boolean)metricReporter.createdByFactory);
    }

    @Test
    void testAdditionalVariablesParsing() {
        String tag1 = "foo";
        String tagValue1 = "bar";
        String tag2 = "fizz";
        String tagValue2 = "buzz";
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test." + MetricOptions.REPORTER_FACTORY_CLASS.key(), TestReporterFactory.class.getName());
        config.setString("metrics.reporter.test." + MetricOptions.REPORTER_ADDITIONAL_VARIABLES.key(), String.join((CharSequence)",", "foo:bar", "fizz:buzz"));
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        MatcherAssert.assertThat((Object)reporterSetup.getAdditionalVariables(), (Matcher)IsMapContaining.hasEntry((Object)ScopeFormat.asVariable((String)"foo"), (Object)"bar"));
        MatcherAssert.assertThat((Object)reporterSetup.getAdditionalVariables(), (Matcher)IsMapContaining.hasEntry((Object)ScopeFormat.asVariable((String)"fizz"), (Object)"buzz"));
    }

    @InstantiateViaFactory(factoryClassName="org.apache.flink.runtime.metrics.ReporterSetupTest$InstantiationTypeTrackingTestReporterFactory")
    protected static class InstantiationTypeTrackingTestReporter2
    extends InstantiationTypeTrackingTestReporter {
        protected InstantiationTypeTrackingTestReporter2() {
        }
    }

    protected static class InstantiationTypeTrackingTestReporter
    extends TestReporter {
        private final boolean createdByFactory;

        public InstantiationTypeTrackingTestReporter() {
            this(false);
        }

        InstantiationTypeTrackingTestReporter(boolean createdByFactory) {
            this.createdByFactory = createdByFactory;
        }

        public boolean isCreatedByFactory() {
            return this.createdByFactory;
        }
    }

    @InterceptInstantiationViaReflection(reporterClassName="org.apache.flink.runtime.metrics.ReporterSetupTest$InstantiationTypeTrackingTestReporter")
    public static class InterceptingInstantiationTypeTrackingTestReporterFactory
    implements MetricReporterFactory {
        public MetricReporter createMetricReporter(Properties config) {
            return new InstantiationTypeTrackingTestReporter(true);
        }
    }

    public static class InstantiationTypeTrackingTestReporterFactory
    implements MetricReporterFactory {
        public MetricReporter createMetricReporter(Properties config) {
            return new InstantiationTypeTrackingTestReporter(true);
        }
    }

    public static class FailingFactory
    implements MetricReporterFactory {
        public MetricReporter createMetricReporter(Properties config) {
            throw new RuntimeException();
        }
    }

    public static class TestReporterFactory
    implements MetricReporterFactory {
        static final MetricReporter REPORTER = new TestReporter();

        public MetricReporter createMetricReporter(Properties config) {
            return REPORTER;
        }
    }

    public static class ConfigExposingReporterFactory
    implements MetricReporterFactory {
        static Properties lastConfig = null;

        public MetricReporter createMetricReporter(Properties config) {
            lastConfig = config;
            return new TestReporter();
        }
    }

    public static class TestReporter13
    extends TestReporter {
        public static boolean wasOpened = false;

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    public static class TestReporter12
    extends TestReporter {
        public static boolean wasOpened = false;

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    public static class TestReporter11
    extends TestReporter {
        public static boolean wasOpened = false;

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    public static class TestReporter2
    extends TestReporter {
    }

    public static class TestReporter1
    extends TestReporter {
    }
}

