/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.leaderelection.DefaultMultipleComponentLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderElectionEventHandler;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.LeaderInformationWithComponentId;
import org.apache.flink.runtime.leaderelection.MultipleComponentLeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.TestingMultipleComponentLeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.TestingMultipleComponentLeaderElectionDriverFactory;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerExtension;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;

@ExtendWith(value={TestLoggerExtension.class})
class DefaultMultipleComponentLeaderElectionServiceTest {
    @RegisterExtension
    public final TestingFatalErrorHandlerExtension fatalErrorHandlerExtension = new TestingFatalErrorHandlerExtension();

    DefaultMultipleComponentLeaderElectionServiceTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void isLeaderInformsAllRegisteredLeaderElectionEventHandlers() throws Exception {
        TestingMultipleComponentLeaderElectionDriver leaderElectionDriver = TestingMultipleComponentLeaderElectionDriver.newBuilder().build();
        try (DefaultMultipleComponentLeaderElectionService leaderElectionService = this.createDefaultMultiplexingLeaderElectionService(leaderElectionDriver);){
            Collection eventListeners = Stream.generate(SimpleTestingLeaderElectionEventListener::new).limit(4L).collect(Collectors.toList());
            int counter = 0;
            for (SimpleTestingLeaderElectionEventListener eventListener : eventListeners) {
                leaderElectionService.registerLeaderElectionEventHandler(String.valueOf(counter), (LeaderElectionEventHandler)eventListener);
                ++counter;
            }
            leaderElectionDriver.grantLeadership();
            for (SimpleTestingLeaderElectionEventListener eventListener : eventListeners) {
                Assertions.assertThat((boolean)eventListener.hasLeadership()).isTrue();
            }
        }
    }

    private DefaultMultipleComponentLeaderElectionService createDefaultMultiplexingLeaderElectionService(TestingMultipleComponentLeaderElectionDriver leaderElectionDriver) throws Exception {
        return new DefaultMultipleComponentLeaderElectionService((FatalErrorHandler)this.fatalErrorHandlerExtension.getTestingFatalErrorHandler(), (MultipleComponentLeaderElectionDriverFactory)new TestingMultipleComponentLeaderElectionDriverFactory(leaderElectionDriver), org.apache.flink.util.concurrent.Executors.newDirectExecutorService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void notLeaderInformsAllRegisteredLeaderElectionEventHandlers() throws Exception {
        TestingMultipleComponentLeaderElectionDriver leaderElectionDriver = TestingMultipleComponentLeaderElectionDriver.newBuilder().build();
        try (DefaultMultipleComponentLeaderElectionService leaderElectionService = this.createDefaultMultiplexingLeaderElectionService(leaderElectionDriver);){
            Collection eventListeners = Stream.generate(SimpleTestingLeaderElectionEventListener::new).limit(4L).collect(Collectors.toList());
            int counter = 0;
            for (SimpleTestingLeaderElectionEventListener eventListener : eventListeners) {
                leaderElectionService.registerLeaderElectionEventHandler(String.valueOf(counter), (LeaderElectionEventHandler)eventListener);
                ++counter;
            }
            leaderElectionDriver.grantLeadership();
            leaderElectionDriver.revokeLeadership();
            for (SimpleTestingLeaderElectionEventListener eventListener : eventListeners) {
                Assertions.assertThat((boolean)eventListener.hasLeadership()).isFalse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unregisteredEventHandlersAreNotNotified() throws Exception {
        TestingMultipleComponentLeaderElectionDriver leaderElectionDriver = TestingMultipleComponentLeaderElectionDriver.newBuilder().build();
        try (DefaultMultipleComponentLeaderElectionService leaderElectionService = this.createDefaultMultiplexingLeaderElectionService(leaderElectionDriver);){
            SimpleTestingLeaderElectionEventListener leaderElectionEventHandler = new SimpleTestingLeaderElectionEventListener();
            String componentId = "foobar";
            leaderElectionService.registerLeaderElectionEventHandler("foobar", (LeaderElectionEventHandler)leaderElectionEventHandler);
            leaderElectionService.unregisterLeaderElectionEventHandler("foobar");
            leaderElectionDriver.grantLeadership();
            Assertions.assertThat((boolean)leaderElectionEventHandler.hasLeadership()).isFalse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void newlyRegisteredEventHandlersAreInformedAboutLeadership() throws Exception {
        TestingMultipleComponentLeaderElectionDriver leaderElectionDriver = TestingMultipleComponentLeaderElectionDriver.newBuilder().build();
        try (DefaultMultipleComponentLeaderElectionService leaderElectionService = this.createDefaultMultiplexingLeaderElectionService(leaderElectionDriver);){
            leaderElectionDriver.grantLeadership();
            SimpleTestingLeaderElectionEventListener leaderElectionEventHandler = new SimpleTestingLeaderElectionEventListener();
            leaderElectionService.registerLeaderElectionEventHandler("foobar", (LeaderElectionEventHandler)leaderElectionEventHandler);
            Assertions.assertThat((boolean)leaderElectionEventHandler.hasLeadership()).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void allKnownLeaderInformationCallsEventHandlers() throws Exception {
        TestingMultipleComponentLeaderElectionDriver leaderElectionDriver = TestingMultipleComponentLeaderElectionDriver.newBuilder().build();
        try (DefaultMultipleComponentLeaderElectionService leaderElectionService = this.createDefaultMultiplexingLeaderElectionService(leaderElectionDriver);){
            leaderElectionDriver.grantLeadership();
            Collection<Component> knownLeaderInformation = this.createComponents(3);
            Collection<Component> unknownLeaderInformation = this.createComponents(2);
            this.registerLeaderElectionEventHandler(leaderElectionService, knownLeaderInformation);
            this.registerLeaderElectionEventHandler(leaderElectionService, unknownLeaderInformation);
            leaderElectionService.notifyAllKnownLeaderInformation((Collection)knownLeaderInformation.stream().map(component -> LeaderInformationWithComponentId.create((String)component.getComponentId(), (LeaderInformation)component.getLeaderInformation())).collect(Collectors.toList()));
            for (Component component2 : knownLeaderInformation) {
                Assertions.assertThat((Object)component2.getLeaderElectionEventListener().getLeaderInformation()).isEqualTo((Object)component2.getLeaderInformation());
            }
            for (Component component2 : unknownLeaderInformation) {
                Assertions.assertThat((Object)component2.getLeaderElectionEventListener().getLeaderInformation()).isEqualTo((Object)LeaderInformation.empty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void allKnownLeaderInformationDoesNotBlock() throws Exception {
        TestingMultipleComponentLeaderElectionDriver leaderElectionDriver = TestingMultipleComponentLeaderElectionDriver.newBuilder().build();
        try (DefaultMultipleComponentLeaderElectionService leaderElectionService = new DefaultMultipleComponentLeaderElectionService((FatalErrorHandler)this.fatalErrorHandlerExtension.getTestingFatalErrorHandler(), (MultipleComponentLeaderElectionDriverFactory)new TestingMultipleComponentLeaderElectionDriverFactory(leaderElectionDriver), (ExecutorService)Executors.newSingleThreadScheduledExecutor());){
            leaderElectionDriver.grantLeadership();
            String knownLeaderInformationComponent = "knownLeaderInformationComponent";
            BlockingLeaderElectionEventHandler knownLeaderElectionEventHandler = new BlockingLeaderElectionEventHandler();
            leaderElectionService.registerLeaderElectionEventHandler("knownLeaderInformationComponent", (LeaderElectionEventHandler)knownLeaderElectionEventHandler);
            BlockingLeaderElectionEventHandler unknownLeaderElectionEventHandler = new BlockingLeaderElectionEventHandler();
            leaderElectionService.registerLeaderElectionEventHandler("unknownLeaderInformationComponent", (LeaderElectionEventHandler)unknownLeaderElectionEventHandler);
            leaderElectionService.notifyAllKnownLeaderInformation(Collections.singleton(LeaderInformationWithComponentId.create((String)"knownLeaderInformationComponent", (LeaderInformation)LeaderInformation.known((UUID)UUID.randomUUID(), (String)"localhost"))));
            knownLeaderElectionEventHandler.unblock();
            unknownLeaderElectionEventHandler.unblock();
        }
    }

    private void registerLeaderElectionEventHandler(DefaultMultipleComponentLeaderElectionService leaderElectionService, Collection<Component> knownLeaderInformation) {
        for (Component component : knownLeaderInformation) {
            leaderElectionService.registerLeaderElectionEventHandler(component.getComponentId(), (LeaderElectionEventHandler)component.getLeaderElectionEventListener());
        }
    }

    private Collection<Component> createComponents(int numberComponents) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (int i = 0; i < numberComponents; ++i) {
            result.add(new Component(UUID.randomUUID().toString(), new SimpleTestingLeaderElectionEventListener(), LeaderInformation.known((UUID)UUID.randomUUID(), (String)"localhost")));
        }
        return result;
    }

    private static final class SimpleTestingLeaderElectionEventListener
    implements LeaderElectionEventHandler {
        private boolean hasLeadership = false;
        @Nullable
        private LeaderInformation leaderInformation = null;

        SimpleTestingLeaderElectionEventListener() {
        }

        public boolean hasLeadership() {
            return this.hasLeadership;
        }

        public void onGrantLeadership(UUID newLeaderSessionId) {
            this.hasLeadership = true;
        }

        public void onRevokeLeadership() {
            this.hasLeadership = false;
            this.leaderInformation = null;
        }

        public void onLeaderInformationChange(LeaderInformation leaderInformation) {
            this.leaderInformation = leaderInformation;
        }

        @Nullable
        LeaderInformation getLeaderInformation() {
            return this.leaderInformation;
        }
    }

    private static final class Component {
        private final String componentId;
        private final SimpleTestingLeaderElectionEventListener leaderElectionEventListener;
        private final LeaderInformation leaderInformation;

        private Component(String componentId, SimpleTestingLeaderElectionEventListener leaderElectionEventListener, LeaderInformation leaderInformation) {
            this.componentId = componentId;
            this.leaderElectionEventListener = leaderElectionEventListener;
            this.leaderInformation = leaderInformation;
        }

        String getComponentId() {
            return this.componentId;
        }

        LeaderInformation getLeaderInformation() {
            return this.leaderInformation;
        }

        SimpleTestingLeaderElectionEventListener getLeaderElectionEventListener() {
            return this.leaderElectionEventListener;
        }
    }

    private static final class BlockingLeaderElectionEventHandler
    implements LeaderElectionEventHandler {
        private final OneShotLatch waitingLatch = new OneShotLatch();

        private BlockingLeaderElectionEventHandler() {
        }

        public void onGrantLeadership(UUID newLeaderSessionId) {
        }

        public void onRevokeLeadership() {
        }

        public void onLeaderInformationChange(LeaderInformation leaderInformation) {
            try {
                this.waitingLatch.await();
            }
            catch (InterruptedException e) {
                ExceptionUtils.checkInterrupted((Throwable)e);
            }
        }

        void unblock() {
            this.waitingLatch.trigger();
        }
    }
}

