/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.HsBufferContext;
import org.apache.flink.runtime.io.network.partition.hybrid.HybridShuffleTestUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.NotThrownAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class HsBufferContextTest {
    private static final int BUFFER_SIZE = 16;
    private static final int SUBPARTITION_ID = 0;
    private static final int BUFFER_INDEX = 0;
    private HsBufferContext bufferContext;

    HsBufferContextTest() {
    }

    @BeforeEach
    void before() {
        this.bufferContext = HsBufferContextTest.createBufferContext();
    }

    @Test
    void testBufferStartSpillingRefCount() {
        Buffer buffer = this.bufferContext.getBuffer();
        CompletableFuture<Object> spilledFuture = new CompletableFuture<Object>();
        this.bufferContext.startSpilling(spilledFuture);
        Assertions.assertThat((boolean)this.bufferContext.isSpillStarted()).isTrue();
        Assertions.assertThat((int)buffer.refCnt()).isEqualTo(2);
        spilledFuture.complete(null);
        Assertions.assertThat((int)buffer.refCnt()).isEqualTo(1);
    }

    @Test
    void testBufferStartSpillingRepeatedly() {
        Assertions.assertThat((boolean)this.bufferContext.startSpilling(new CompletableFuture())).isTrue();
        Assertions.assertThat((boolean)this.bufferContext.startSpilling(new CompletableFuture())).isFalse();
    }

    @Test
    void testBufferReleaseRefCount() {
        Buffer buffer = this.bufferContext.getBuffer();
        Assertions.assertThat((int)buffer.refCnt()).isEqualTo(1);
        this.bufferContext.release();
        Assertions.assertThat((boolean)this.bufferContext.isReleased()).isTrue();
        Assertions.assertThat((boolean)buffer.isRecycled()).isTrue();
    }

    @Test
    void testBufferReleaseRepeatedly() {
        this.bufferContext.release();
        ((NotThrownAssert)Assertions.assertThatNoException().as("repeatedly release should only recycle buffer once.", new Object[0])).isThrownBy(() -> this.bufferContext.release());
    }

    @Test
    void testBufferConsumed() {
        Buffer buffer = this.bufferContext.getBuffer();
        this.bufferContext.consumed();
        Assertions.assertThat((boolean)this.bufferContext.isConsumed()).isTrue();
        Assertions.assertThat((int)buffer.refCnt()).isEqualTo(2);
    }

    @Test
    void testBufferConsumedRepeatedly() {
        this.bufferContext.consumed();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.bufferContext.consumed()).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Consume buffer repeatedly is unexpected.");
    }

    @Test
    void testBufferStartSpillOrConsumedAfterReleased() {
        this.bufferContext.release();
        Assertions.assertThat((boolean)this.bufferContext.startSpilling(new CompletableFuture())).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.bufferContext.consumed()).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Buffer is already released.");
    }

    @Test
    void testBufferStartSpillingThenRelease() {
        Buffer buffer = this.bufferContext.getBuffer();
        CompletableFuture<Object> spilledFuture = new CompletableFuture<Object>();
        this.bufferContext.startSpilling(spilledFuture);
        this.bufferContext.release();
        spilledFuture.complete(null);
        Assertions.assertThat((boolean)buffer.isRecycled()).isTrue();
    }

    @Test
    void testBufferConsumedThenRelease() {
        Buffer buffer = this.bufferContext.getBuffer();
        this.bufferContext.consumed();
        this.bufferContext.release();
        Assertions.assertThat((int)buffer.refCnt()).isEqualTo(1);
    }

    private static HsBufferContext createBufferContext() {
        return new HsBufferContext(HybridShuffleTestUtils.createBuffer(16, false), 0, 0);
    }
}

