/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.disk.FileChannelManagerImpl;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartition;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartitionReader;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartitionType;
import org.apache.flink.runtime.io.network.partition.BoundedData;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.NoOpBufferAvailablityListener;
import org.apache.flink.runtime.io.network.partition.PartitionTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SubpartitionTestBase;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.Preconditions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BoundedBlockingSubpartitionTest
extends SubpartitionTestBase {
    private static final String tempDir = EnvironmentInformation.getTemporaryFileDirectory();
    private static FileChannelManager fileChannelManager;
    private final BoundedBlockingSubpartitionType type;
    private final boolean sslEnabled;
    @ClassRule
    public static final TemporaryFolder TMP_DIR;

    @Parameterized.Parameters(name="type = {0}, sslEnabled = {1}")
    public static Collection<Object[]> parameters() {
        return Arrays.stream(BoundedBlockingSubpartitionType.values()).map(type -> new Object[][]{{type, true}, {type, false}}).flatMap(Arrays::stream).collect(Collectors.toList());
    }

    @BeforeClass
    public static void setUp() {
        fileChannelManager = new FileChannelManagerImpl(new String[]{tempDir}, "testing");
    }

    @AfterClass
    public static void shutdown() throws Exception {
        fileChannelManager.close();
    }

    public BoundedBlockingSubpartitionTest(BoundedBlockingSubpartitionType type, boolean sslEnabled) {
        this.type = type;
        this.sslEnabled = sslEnabled;
    }

    @Test
    public void testCreateReaderBeforeFinished() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        try {
            partition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        partition.release();
    }

    @Test
    public void testCloseBoundedData() throws Exception {
        TestingBoundedDataReader reader = new TestingBoundedDataReader();
        TestingBoundedData data = new TestingBoundedData(reader);
        BoundedBlockingSubpartitionReader bbspr = new BoundedBlockingSubpartitionReader((BoundedBlockingSubpartition)this.createSubpartition(), (BoundedData)data, 10, (BufferAvailabilityListener)new NoOpBufferAvailablityListener());
        bbspr.releaseAllResources();
        Assert.assertTrue((boolean)reader.closed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecycleCurrentBufferOnFailure() throws Exception {
        ResultPartition resultPartition = PartitionTestUtils.createPartition(ResultPartitionType.BLOCKING, fileChannelManager);
        BoundedBlockingSubpartition subpartition = new BoundedBlockingSubpartition(0, resultPartition, (BoundedData)new FailingBoundedData(), !this.sslEnabled && this.type == BoundedBlockingSubpartitionType.FILE);
        BufferConsumer consumer = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(100);
        try {
            try {
                subpartition.add(consumer);
                subpartition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
                Assert.fail((String)"should fail with an exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertFalse((boolean)consumer.isRecycled());
            Assert.assertNotNull((Object)subpartition.getCurrentBuffer());
            Assert.assertFalse((boolean)subpartition.getCurrentBuffer().isRecycled());
        }
        finally {
            subpartition.release();
            Assert.assertTrue((boolean)consumer.isRecycled());
            Assert.assertNull((Object)subpartition.getCurrentBuffer());
        }
    }

    @Override
    ResultSubpartition createSubpartition() throws Exception {
        ResultPartition resultPartition = PartitionTestUtils.createPartition(ResultPartitionType.BLOCKING, fileChannelManager);
        return this.type.create(0, resultPartition, new File(TMP_DIR.newFolder(), "subpartition"), 32768, this.sslEnabled);
    }

    @Override
    ResultSubpartition createFailingWritesSubpartition() throws Exception {
        ResultPartition resultPartition = PartitionTestUtils.createPartition(ResultPartitionType.BLOCKING, fileChannelManager);
        return new BoundedBlockingSubpartition(0, resultPartition, (BoundedData)new FailingBoundedData(), !this.sslEnabled && this.type == BoundedBlockingSubpartitionType.FILE);
    }

    static {
        TMP_DIR = new TemporaryFolder();
    }

    private static class TestingBoundedDataReader
    implements BoundedData.Reader {
        boolean closed;

        private TestingBoundedDataReader() {
        }

        @Nullable
        public Buffer nextBuffer() throws IOException {
            return null;
        }

        public void close() throws IOException {
            this.closed = true;
        }
    }

    private static class TestingBoundedData
    implements BoundedData {
        private BoundedData.Reader reader;

        private TestingBoundedData(BoundedData.Reader reader) {
            this.reader = (BoundedData.Reader)Preconditions.checkNotNull((Object)reader);
        }

        public void writeBuffer(Buffer buffer) throws IOException {
        }

        public void finishWrite() throws IOException {
        }

        public BoundedData.Reader createReader(ResultSubpartitionView ignored) throws IOException {
            return this.reader;
        }

        public long getSize() {
            throw new UnsupportedOperationException();
        }

        public Path getFilePath() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }

    private static class FailingBoundedData
    implements BoundedData {
        private FailingBoundedData() {
        }

        public void writeBuffer(Buffer buffer) throws IOException {
            throw new IOException("test");
        }

        public void finishWrite() throws IOException {
            throw new UnsupportedOperationException();
        }

        public BoundedData.Reader createReader(ResultSubpartitionView subpartitionView) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getSize() {
            throw new UnsupportedOperationException();
        }

        public Path getFilePath() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }
}

