/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.AutoCloseableRegistry;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.LocalBufferPool;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.testutils.executor.TestExecutorResource;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class LocalBufferPoolTest
extends TestLogger {
    private static final int numBuffers = 1024;
    private static final int memorySegmentSize = 128;
    private NetworkBufferPool networkBufferPool;
    private BufferPool localBufferPool;
    @ClassRule
    public static final TestExecutorResource<ExecutorService> EXECUTOR_RESOURCE = new TestExecutorResource(() -> Executors.newCachedThreadPool());

    @Before
    public void setupLocalBufferPool() throws Exception {
        this.networkBufferPool = new NetworkBufferPool(1024, 128);
        this.localBufferPool = new LocalBufferPool(this.networkBufferPool, 1);
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
    }

    @After
    public void destroyAndVerifyAllBuffersReturned() {
        if (!this.localBufferPool.isDestroyed()) {
            this.localBufferPool.lazyDestroy();
        }
        String msg = "Did not return all buffers to memory segment pool after test.";
        Assert.assertEquals((String)msg, (long)1024L, (long)this.networkBufferPool.getNumberOfAvailableMemorySegments());
        this.networkBufferPool.destroyAllBufferPools();
        this.networkBufferPool.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReserveSegments() throws Exception {
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(2, 128, Duration.ofSeconds(2L));
        try {
            BufferPool bufferPool1 = networkBufferPool.createBufferPool(1, 2);
            Assert.assertThrows(IllegalArgumentException.class, () -> bufferPool1.reserveSegments(2));
            ArrayList<Buffer> buffers = new ArrayList<Buffer>(2);
            buffers.add(bufferPool1.requestBuffer());
            buffers.add(bufferPool1.requestBuffer());
            Assert.assertEquals((long)2L, (long)buffers.size());
            BufferPool bufferPool2 = networkBufferPool.createBufferPool(1, 10);
            Assert.assertThrows(IOException.class, () -> bufferPool2.reserveSegments(1));
            Assert.assertFalse((boolean)bufferPool2.isAvailable());
            buffers.forEach(Buffer::recycleBuffer);
            bufferPool1.lazyDestroy();
            bufferPool2.lazyDestroy();
            BufferPool bufferPool3 = networkBufferPool.createBufferPool(2, 10);
            Assert.assertEquals((long)1L, (long)bufferPool3.getNumberOfAvailableMemorySegments());
            bufferPool3.reserveSegments(2);
            Assert.assertEquals((long)2L, (long)bufferPool3.getNumberOfAvailableMemorySegments());
            bufferPool3.lazyDestroy();
            Assert.assertThrows(CancelTaskException.class, () -> bufferPool3.reserveSegments(1));
        }
        finally {
            networkBufferPool.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testReserveSegmentsAndCancel() throws Exception {
        int totalSegments = 4;
        int segmentsToReserve = 2;
        NetworkBufferPool globalPool = new NetworkBufferPool(totalSegments, 128);
        BufferPool localPool1 = globalPool.createBufferPool(segmentsToReserve, totalSegments);
        ArrayList<MemorySegment> segments = new ArrayList<MemorySegment>();
        try {
            for (int i = 0; i < totalSegments; ++i) {
                segments.add(localPool1.requestMemorySegmentBlocking());
            }
            BufferPool localPool2 = globalPool.createBufferPool(segmentsToReserve, totalSegments);
            Thread reserveThread = new Thread(() -> {
                try {
                    localPool2.reserveSegments(segmentsToReserve);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            reserveThread.start();
            Thread.sleep(100L);
            Thread cancelThread = new Thread(() -> {
                localPool1.lazyDestroy();
                localPool2.lazyDestroy();
            });
            cancelThread.start();
            Thread interruptThread = new Thread(() -> {
                try {
                    do {
                        reserveThread.interrupt();
                        Thread.sleep(100L);
                    } while (reserveThread.isAlive() || cancelThread.isAlive());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            interruptThread.start();
            interruptThread.join();
        }
        finally {
            segments.forEach(arg_0 -> ((BufferPool)localPool1).recycle(arg_0));
            localPool1.lazyDestroy();
            Assert.assertEquals((long)0L, (long)globalPool.getNumberOfUsedMemorySegments());
            globalPool.destroy();
        }
    }

    @Test
    public void testRequestMoreThanAvailable() {
        this.localBufferPool.setNumBuffers(1024);
        ArrayList<Buffer> requests = new ArrayList<Buffer>(1024);
        for (int i = 1; i <= 1024; ++i) {
            Buffer buffer2 = this.localBufferPool.requestBuffer();
            Assert.assertEquals((long)Math.min(i + 1, 1024), (long)this.getNumRequestedFromMemorySegmentPool());
            Assert.assertNotNull((Object)buffer2);
            requests.add(buffer2);
        }
        Buffer buffer = this.localBufferPool.requestBuffer();
        Assert.assertEquals((long)1024L, (long)this.getNumRequestedFromMemorySegmentPool());
        Assert.assertNull((Object)buffer);
        for (Buffer buffer2 : requests) {
            buffer2.recycleBuffer();
        }
    }

    @Test
    public void testSetNumAfterDestroyDoesNotProactivelyFetchSegments() {
        this.localBufferPool.setNumBuffers(2);
        Assert.assertEquals((long)2L, (long)this.localBufferPool.getNumBuffers());
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        this.localBufferPool.lazyDestroy();
        this.localBufferPool.setNumBuffers(3);
        Assert.assertEquals((long)3L, (long)this.localBufferPool.getNumBuffers());
        Assert.assertEquals((long)0L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
    }

    @Test
    public void testRecycleAfterDestroy() {
        this.localBufferPool.setNumBuffers(1024);
        ArrayList<Buffer> requests = new ArrayList<Buffer>(1024);
        for (int i = 0; i < 1024; ++i) {
            requests.add(this.localBufferPool.requestBuffer());
        }
        this.localBufferPool.lazyDestroy();
        Assert.assertEquals((long)1024L, (long)this.getNumRequestedFromMemorySegmentPool());
        for (Buffer buffer : requests) {
            buffer.recycleBuffer();
        }
    }

    @Test
    @Timeout(value=30L)
    public void testRequestBuffersOnRecycle() throws Exception {
        BufferPool bufferPool1 = this.networkBufferPool.createBufferPool(512, 2048);
        ArrayList<MemorySegment> segments = new ArrayList<MemorySegment>();
        for (int i = 0; i < 1023; ++i) {
            segments.add(bufferPool1.requestMemorySegmentBlocking());
        }
        final BufferPool bufferPool2 = this.networkBufferPool.createBufferPool(512, 512);
        final ArrayList segments2 = new ArrayList();
        CheckedThread checkedThread = new CheckedThread(){

            public void go() throws Exception {
                for (int i = 0; i < 512; ++i) {
                    segments2.add(bufferPool2.requestMemorySegmentBlocking());
                }
            }
        };
        checkedThread.start();
        for (MemorySegment segment : segments) {
            bufferPool1.recycle(segment);
        }
        bufferPool1.lazyDestroy();
        checkedThread.sync();
        for (MemorySegment segment : segments2) {
            bufferPool2.recycle(segment);
        }
        bufferPool2.lazyDestroy();
    }

    @Test
    public void testRecycleExcessBuffersAfterRecycling() {
        int i;
        this.localBufferPool.setNumBuffers(1024);
        ArrayList<Buffer> requests = new ArrayList<Buffer>(1024);
        for (i = 1; i <= 1024; ++i) {
            requests.add(this.localBufferPool.requestBuffer());
        }
        Assert.assertEquals((long)1024L, (long)this.getNumRequestedFromMemorySegmentPool());
        this.localBufferPool.setNumBuffers(512);
        Assert.assertEquals((long)1024L, (long)this.getNumRequestedFromMemorySegmentPool());
        for (i = 1; i < 512; ++i) {
            ((Buffer)requests.remove(0)).recycleBuffer();
            Assert.assertEquals((long)(1024 - i), (long)this.getNumRequestedFromMemorySegmentPool());
        }
        for (Buffer buffer : requests) {
            buffer.recycleBuffer();
        }
    }

    @Test
    public void testRecycleExcessBuffersAfterChangingNumBuffers() {
        this.localBufferPool.setNumBuffers(1024);
        ArrayList<Buffer> requests = new ArrayList<Buffer>(1024);
        for (int i = 1; i <= 1024; ++i) {
            requests.add(this.localBufferPool.requestBuffer());
        }
        for (Buffer buffer : requests) {
            buffer.recycleBuffer();
        }
        Assert.assertEquals((long)1024L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        this.localBufferPool.setNumBuffers(512);
        Assert.assertEquals((long)512L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetLessThanRequiredNumBuffers() {
        this.localBufferPool.setNumBuffers(1);
        this.localBufferPool.setNumBuffers(0);
    }

    @Test
    public void testPendingRequestWithListenersAfterRecycle() {
        CountBufferListener listener1 = new CountBufferListener();
        CountBufferListener listener2 = new CountBufferListener();
        Buffer available = this.localBufferPool.requestBuffer();
        Assert.assertNull((Object)this.localBufferPool.requestBuffer());
        Assert.assertTrue((boolean)this.localBufferPool.addBufferListener((BufferListener)listener1));
        Assert.assertTrue((boolean)this.localBufferPool.addBufferListener((BufferListener)listener2));
        ((Buffer)Preconditions.checkNotNull((Object)available)).recycleBuffer();
        Assert.assertEquals((long)1L, (long)listener1.getCount());
        Assert.assertEquals((long)1L, (long)listener1.getCount());
        Assert.assertFalse((boolean)this.localBufferPool.addBufferListener((BufferListener)listener1));
        Assert.assertFalse((boolean)this.localBufferPool.addBufferListener((BufferListener)listener2));
    }

    @Test
    public void testCancelPendingRequestsAfterDestroy() {
        BufferListener listener = (BufferListener)Mockito.mock(BufferListener.class);
        this.localBufferPool.setNumBuffers(1);
        Buffer available = this.localBufferPool.requestBuffer();
        Buffer unavailable = this.localBufferPool.requestBuffer();
        Assert.assertNull((Object)unavailable);
        this.localBufferPool.addBufferListener(listener);
        this.localBufferPool.lazyDestroy();
        available.recycleBuffer();
        ((BufferListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notifyBufferDestroyed();
    }

    @Test
    public void testConcurrentRequestRecycle() throws ExecutionException, InterruptedException {
        int i;
        int numConcurrentTasks = 128;
        int numBuffersToRequestPerTask = 1024;
        this.localBufferPool.setNumBuffers(numConcurrentTasks);
        Future[] taskResults = new Future[numConcurrentTasks];
        for (i = 0; i < numConcurrentTasks; ++i) {
            taskResults[i] = EXECUTOR_RESOURCE.getExecutor().submit(new BufferRequesterTask((BufferProvider)this.localBufferPool, numBuffersToRequestPerTask));
        }
        for (i = 0; i < numConcurrentTasks; ++i) {
            Assert.assertTrue((boolean)((Boolean)taskResults[i].get()));
        }
    }

    @Test
    public void testBoundedBuffer() throws Exception {
        this.localBufferPool.lazyDestroy();
        this.localBufferPool = new LocalBufferPool(this.networkBufferPool, 1, 2);
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        Assert.assertEquals((long)2L, (long)this.localBufferPool.getMaxNumberOfMemorySegments());
        this.localBufferPool.setNumBuffers(1);
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        Buffer buffer1 = this.localBufferPool.requestBuffer();
        Assert.assertNotNull((Object)buffer1);
        Assert.assertEquals((long)0L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        Assert.assertNull((Object)this.localBufferPool.requestBuffer());
        Assert.assertEquals((long)0L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        buffer1.recycleBuffer();
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        this.localBufferPool.setNumBuffers(2);
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        buffer1 = this.localBufferPool.requestBuffer();
        Assert.assertNotNull((Object)buffer1);
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        Buffer buffer2 = this.localBufferPool.requestBuffer();
        Assert.assertNotNull((Object)buffer2);
        Assert.assertEquals((long)0L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        Assert.assertNull((Object)this.localBufferPool.requestBuffer());
        Assert.assertEquals((long)0L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        buffer1.recycleBuffer();
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        buffer2.recycleBuffer();
        Assert.assertEquals((long)2L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        this.localBufferPool.setNumBuffers(3);
        Assert.assertEquals((long)2L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        buffer1 = this.localBufferPool.requestBuffer();
        Assert.assertNotNull((Object)buffer1);
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        buffer2 = this.localBufferPool.requestBuffer();
        Assert.assertNotNull((Object)buffer2);
        Assert.assertEquals((long)0L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        Assert.assertNull((Object)this.localBufferPool.requestBuffer());
        Assert.assertEquals((long)0L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        buffer1.recycleBuffer();
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        buffer2.recycleBuffer();
        Assert.assertEquals((long)2L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        this.localBufferPool.setNumBuffers(1);
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        buffer1 = this.localBufferPool.requestBuffer();
        Assert.assertNotNull((Object)buffer1);
        Assert.assertEquals((long)0L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
        Assert.assertNull((Object)this.localBufferPool.requestBuffer());
        buffer1.recycleBuffer();
        Assert.assertEquals((long)1L, (long)this.localBufferPool.getNumberOfAvailableMemorySegments());
    }

    @Test
    public void testMaxBuffersPerChannelAndAvailability() throws Exception {
        this.localBufferPool.lazyDestroy();
        this.localBufferPool = new LocalBufferPool(this.networkBufferPool, 1, Integer.MAX_VALUE, 3, 2, 0);
        this.localBufferPool.setNumBuffers(10);
        Assert.assertTrue((boolean)this.localBufferPool.getAvailableFuture().isDone());
        BufferBuilder bufferBuilder01 = this.localBufferPool.requestBufferBuilderBlocking(0);
        BufferBuilder bufferBuilder11 = this.localBufferPool.requestBufferBuilderBlocking(1);
        Assert.assertTrue((boolean)this.localBufferPool.getAvailableFuture().isDone());
        BufferBuilder bufferBuilder02 = this.localBufferPool.requestBufferBuilderBlocking(0);
        Assert.assertFalse((boolean)this.localBufferPool.getAvailableFuture().isDone());
        BufferBuilder bufferBuilder03 = this.localBufferPool.requestBufferBuilderBlocking(0);
        BufferBuilder bufferBuilder21 = this.localBufferPool.requestBufferBuilderBlocking(2);
        BufferBuilder bufferBuilder22 = this.localBufferPool.requestBufferBuilderBlocking(2);
        Assert.assertFalse((boolean)this.localBufferPool.getAvailableFuture().isDone());
        bufferBuilder11.close();
        Assert.assertFalse((boolean)this.localBufferPool.getAvailableFuture().isDone());
        bufferBuilder21.close();
        Assert.assertFalse((boolean)this.localBufferPool.getAvailableFuture().isDone());
        bufferBuilder02.close();
        Assert.assertFalse((boolean)this.localBufferPool.getAvailableFuture().isDone());
        bufferBuilder01.close();
        Assert.assertTrue((boolean)this.localBufferPool.getAvailableFuture().isDone());
        bufferBuilder03.close();
        Assert.assertTrue((boolean)this.localBufferPool.getAvailableFuture().isDone());
        bufferBuilder22.close();
        Assert.assertTrue((boolean)this.localBufferPool.getAvailableFuture().isDone());
    }

    @Test
    public void testIsAvailableOrNot() throws InterruptedException {
        Assert.assertTrue((boolean)this.localBufferPool.isAvailable());
        try (BufferBuilder bufferBuilder = (BufferBuilder)Preconditions.checkNotNull((Object)this.localBufferPool.requestBufferBuilderBlocking());){
            CompletableFuture availableFuture = this.localBufferPool.getAvailableFuture();
            Assert.assertFalse((boolean)availableFuture.isDone());
            int numLocalBuffers = 5;
            this.localBufferPool.setNumBuffers(5);
            Assert.assertTrue((boolean)availableFuture.isDone());
            Assert.assertTrue((boolean)this.localBufferPool.isAvailable());
            ArrayDeque<Object> buffers = new ArrayDeque<Object>(1024);
            for (int i = 0; i < 4; ++i) {
                Assert.assertTrue((boolean)this.localBufferPool.isAvailable());
                buffers.add(Preconditions.checkNotNull((Object)this.localBufferPool.requestBuffer()));
            }
            Assert.assertFalse((boolean)this.localBufferPool.isAvailable());
            ((Buffer)buffers.pop()).recycleBuffer();
            Assert.assertTrue((boolean)this.localBufferPool.isAvailable());
            for (Buffer buffer : buffers) {
                buffer.recycleBuffer();
            }
            Assert.assertTrue((boolean)this.localBufferPool.isAvailable());
            this.localBufferPool.setNumBuffers(2);
            Assert.assertTrue((boolean)this.localBufferPool.isAvailable());
            Buffer buffer2 = (Buffer)Preconditions.checkNotNull((Object)this.localBufferPool.requestBuffer());
            Assert.assertFalse((boolean)this.localBufferPool.isAvailable());
            buffer2.recycleBuffer();
            Assert.assertTrue((boolean)this.localBufferPool.isAvailable());
            this.localBufferPool.setNumBuffers(1);
            Assert.assertFalse((boolean)this.localBufferPool.getAvailableFuture().isDone());
        }
        Assert.assertTrue((boolean)this.localBufferPool.isAvailable());
        Assert.assertTrue((boolean)this.localBufferPool.getAvailableFuture().isDone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsistentAvailability() throws Exception {
        TestNetworkBufferPool globalPool = new TestNetworkBufferPool(1024, 128);
        try {
            LocalBufferPool localPool = new LocalBufferPool((NetworkBufferPool)globalPool, 1);
            MemorySegment segment = localPool.requestMemorySegmentBlocking();
            localPool.setNumBuffers(2);
            localPool.recycle(segment);
            localPool.lazyDestroy();
        }
        finally {
            globalPool.destroy();
        }
    }

    @Test
    public void testOverdraftBufferAndAvailability() throws Exception {
        for (int maxOverdraftBuffers = 0; maxOverdraftBuffers < 3; ++maxOverdraftBuffers) {
            this.useAllOverdraftBuffersAndCheckIsLegal(4, 3, maxOverdraftBuffers, 2, 1);
            this.useAllOverdraftBuffersAndCheckIsLegal(4, 3, maxOverdraftBuffers, 2, 2);
            this.useAllOverdraftBuffersAndCheckIsLegal(4, 3, maxOverdraftBuffers, 3, 2);
            this.useAllOverdraftBuffersAndCheckIsLegal(8, 5, maxOverdraftBuffers, 2, 1);
            this.useAllOverdraftBuffersAndCheckIsLegal(8, 5, maxOverdraftBuffers, 2, 2);
            this.useAllOverdraftBuffersAndCheckIsLegal(8, 5, maxOverdraftBuffers, 3, 2);
            this.useAllOverdraftBuffersAndCheckIsLegal(12, 10, maxOverdraftBuffers, 2, 1);
            this.useAllOverdraftBuffersAndCheckIsLegal(12, 10, maxOverdraftBuffers, 2, 2);
            this.useAllOverdraftBuffersAndCheckIsLegal(12, 10, maxOverdraftBuffers, 3, 2);
        }
    }

    private void useAllOverdraftBuffersAndCheckIsLegal(int poolSize, int maxBuffersPerChannel, int maxOverdraftBuffers, int numberOfChannels, int availableChannels) throws Exception {
        int i;
        Preconditions.checkArgument((maxBuffersPerChannel > poolSize / numberOfChannels ? 1 : 0) != 0);
        Preconditions.checkArgument((numberOfChannels >= availableChannels ? 1 : 0) != 0);
        LocalBufferPool bufferPool = new LocalBufferPool(this.networkBufferPool, 1, Integer.MAX_VALUE, numberOfChannels, maxBuffersPerChannel, maxOverdraftBuffers);
        bufferPool.setNumBuffers(poolSize);
        HashMap<Integer, AutoCloseableRegistry> closeableRegistryMap = new HashMap<Integer, AutoCloseableRegistry>();
        for (int i2 = 0; i2 < poolSize; ++i2) {
            int targetChannel = i2 % availableChannels;
            BufferBuilder bufferBuilder = bufferPool.requestBufferBuilder(targetChannel);
            Assert.assertNotNull((Object)bufferBuilder);
            closeableRegistryMap.computeIfAbsent(targetChannel, channel -> new AutoCloseableRegistry()).registerCloseable((AutoCloseable)bufferBuilder);
            boolean isAvailable = i2 + 1 < poolSize && i2 < availableChannels * (maxBuffersPerChannel - 1);
            this.assertRequestedBufferAndIsAvailable(bufferPool, 0, i2 + 1, isAvailable);
        }
        AutoCloseableRegistry overdraftCloseableRegistry = new AutoCloseableRegistry();
        for (i = 0; i < maxOverdraftBuffers; ++i) {
            int targetChannel = i % availableChannels;
            BufferBuilder bufferBuilder = bufferPool.requestBufferBuilder(targetChannel);
            Assert.assertNotNull((Object)bufferBuilder);
            overdraftCloseableRegistry.registerCloseable((AutoCloseable)bufferBuilder);
            int numberOfRequestedOverdraftBuffer = i + 1;
            this.assertRequestedBufferAndIsAvailable(bufferPool, numberOfRequestedOverdraftBuffer, poolSize + numberOfRequestedOverdraftBuffer, false);
        }
        for (i = 0; i < numberOfChannels; ++i) {
            Assert.assertNull((Object)bufferPool.requestBufferBuilder(i));
            this.assertRequestedBufferAndIsAvailable(bufferPool, maxOverdraftBuffers, poolSize + maxOverdraftBuffers, false);
        }
        overdraftCloseableRegistry.close();
        this.assertRequestedBufferAndIsAvailable(bufferPool, 0, poolSize, false);
        int numberOfRequestedBuffer = poolSize;
        for (AutoCloseableRegistry closeableRegistry : closeableRegistryMap.values()) {
            closeableRegistry.close();
            this.assertRequestedBufferAndIsAvailable(bufferPool, 0, numberOfRequestedBuffer -= closeableRegistry.getNumberOfRegisteredCloseables(), true);
        }
        bufferPool.lazyDestroy();
    }

    private void assertRequestedBufferAndIsAvailable(LocalBufferPool bufferPool, int numberOfRequestedOverdraftBuffer, int numberOfRequestedBuffer, boolean isAvailable) {
        if (numberOfRequestedOverdraftBuffer > 0) {
            Preconditions.checkArgument((!isAvailable ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)numberOfRequestedOverdraftBuffer, (long)bufferPool.getNumberOfRequestedOverdraftMemorySegments());
        Assert.assertEquals((long)numberOfRequestedBuffer, (long)bufferPool.bestEffortGetNumOfUsedBuffers());
        Assert.assertEquals((Object)isAvailable, (Object)bufferPool.getAvailableFuture().isDone());
    }

    private int getNumRequestedFromMemorySegmentPool() {
        return this.networkBufferPool.getTotalNumberOfMemorySegments() - this.networkBufferPool.getNumberOfAvailableMemorySegments();
    }

    private static class TestNetworkBufferPool
    extends NetworkBufferPool {
        private int requestCounter;

        public TestNetworkBufferPool(int numberOfSegmentsToAllocate, int segmentSize) {
            super(numberOfSegmentsToAllocate, segmentSize);
        }

        @Nullable
        public MemorySegment requestPooledMemorySegment() {
            if (this.requestCounter++ == 1) {
                return null;
            }
            return super.requestPooledMemorySegment();
        }
    }

    private static class BufferRequesterTask
    implements Callable<Boolean> {
        private final BufferProvider bufferProvider;
        private final int numBuffersToRequest;

        private BufferRequesterTask(BufferProvider bufferProvider, int numBuffersToRequest) {
            this.bufferProvider = bufferProvider;
            this.numBuffersToRequest = numBuffersToRequest;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                for (int i = 0; i < this.numBuffersToRequest; ++i) {
                    Buffer buffer = (Buffer)Preconditions.checkNotNull((Object)this.bufferProvider.requestBuffer());
                    buffer.recycleBuffer();
                }
            }
            catch (Throwable t) {
                return false;
            }
            return true;
        }
    }

    private static class CountBufferListener
    implements BufferListener {
        private final AtomicInteger times = new AtomicInteger(0);

        private CountBufferListener() {
        }

        public boolean notifyBufferAvailable(Buffer buffer) {
            this.times.incrementAndGet();
            buffer.recycleBuffer();
            return true;
        }

        public void notifyBufferDestroyed() {
        }

        int getCount() {
            return this.times.get();
        }
    }
}

