/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedJobResultStore;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.StandaloneJobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;

public class TestingHighAvailabilityServicesBuilder {
    private LeaderRetrievalService resourceManagerLeaderRetriever = new StandaloneLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
    private LeaderRetrievalService dispatcherLeaderRetriever = new StandaloneLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
    private LeaderRetrievalService webMonitorEndpointLeaderRetriever = new StandaloneLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
    private Function<JobID, LeaderRetrievalService> jobMasterLeaderRetrieverFunction = jobId -> new StandaloneLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
    private Function<JobID, LeaderElectionService> jobMasterLeaderElectionServiceFunction = jobId -> new StandaloneLeaderElectionService();
    private LeaderElectionService resourceManagerLeaderElectionService = new StandaloneLeaderElectionService();
    private LeaderElectionService dispatcherLeaderElectionService = new StandaloneLeaderElectionService();
    private LeaderElectionService webMonitorEndpointLeaderElectionService = new StandaloneLeaderElectionService();
    private CheckpointRecoveryFactory checkpointRecoveryFactory = new StandaloneCheckpointRecoveryFactory();
    private JobGraphStore jobGraphStore = new StandaloneJobGraphStore();
    private JobResultStore jobResultStore = new EmbeddedJobResultStore();
    private CompletableFuture<Void> closeFuture = new CompletableFuture();
    private CompletableFuture<Void> closeAndCleanupAllDataFuture = new CompletableFuture();

    public TestingHighAvailabilityServices build() {
        TestingHighAvailabilityServices testingHighAvailabilityServices = new TestingHighAvailabilityServices();
        testingHighAvailabilityServices.setResourceManagerLeaderRetriever(this.resourceManagerLeaderRetriever);
        testingHighAvailabilityServices.setDispatcherLeaderRetriever(this.dispatcherLeaderRetriever);
        testingHighAvailabilityServices.setClusterRestEndpointLeaderRetriever(this.webMonitorEndpointLeaderRetriever);
        testingHighAvailabilityServices.setJobMasterLeaderRetrieverFunction(this.jobMasterLeaderRetrieverFunction);
        testingHighAvailabilityServices.setJobMasterLeaderElectionServiceFunction(this.jobMasterLeaderElectionServiceFunction);
        testingHighAvailabilityServices.setResourceManagerLeaderElectionService(this.resourceManagerLeaderElectionService);
        testingHighAvailabilityServices.setDispatcherLeaderElectionService(this.dispatcherLeaderElectionService);
        testingHighAvailabilityServices.setClusterRestEndpointLeaderElectionService(this.webMonitorEndpointLeaderElectionService);
        testingHighAvailabilityServices.setCheckpointRecoveryFactory(this.checkpointRecoveryFactory);
        testingHighAvailabilityServices.setJobGraphStore(this.jobGraphStore);
        testingHighAvailabilityServices.setJobResultStore(this.jobResultStore);
        testingHighAvailabilityServices.setCloseFuture(this.closeFuture);
        testingHighAvailabilityServices.setCloseAndCleanupAllDataFuture(this.closeAndCleanupAllDataFuture);
        return testingHighAvailabilityServices;
    }

    public TestingHighAvailabilityServicesBuilder setResourceManagerLeaderRetriever(LeaderRetrievalService resourceManagerLeaderRetriever) {
        this.resourceManagerLeaderRetriever = resourceManagerLeaderRetriever;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setDispatcherLeaderRetriever(LeaderRetrievalService dispatcherLeaderRetriever) {
        this.dispatcherLeaderRetriever = dispatcherLeaderRetriever;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setWebMonitorEndpointLeaderRetriever(LeaderRetrievalService webMonitorEndpointLeaderRetriever) {
        this.webMonitorEndpointLeaderRetriever = webMonitorEndpointLeaderRetriever;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setJobMasterLeaderRetrieverFunction(Function<JobID, LeaderRetrievalService> jobMasterLeaderRetrieverFunction) {
        this.jobMasterLeaderRetrieverFunction = jobMasterLeaderRetrieverFunction;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setJobMasterLeaderElectionServiceFunction(Function<JobID, LeaderElectionService> jobMasterLeaderElectionServiceFunction) {
        this.jobMasterLeaderElectionServiceFunction = jobMasterLeaderElectionServiceFunction;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setResourceManagerLeaderElectionService(LeaderElectionService resourceManagerLeaderElectionService) {
        this.resourceManagerLeaderElectionService = resourceManagerLeaderElectionService;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setDispatcherLeaderElectionService(LeaderElectionService dispatcherLeaderElectionService) {
        this.dispatcherLeaderElectionService = dispatcherLeaderElectionService;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setWebMonitorEndpointLeaderElectionService(LeaderElectionService webMonitorEndpointLeaderElectionService) {
        this.webMonitorEndpointLeaderElectionService = webMonitorEndpointLeaderElectionService;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setCheckpointRecoveryFactory(CheckpointRecoveryFactory checkpointRecoveryFactory) {
        this.checkpointRecoveryFactory = checkpointRecoveryFactory;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setJobGraphStore(JobGraphStore jobGraphStore) {
        this.jobGraphStore = jobGraphStore;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setJobResultStore(JobResultStore jobResultStore) {
        this.jobResultStore = jobResultStore;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setCloseFuture(CompletableFuture<Void> closeFuture) {
        this.closeFuture = closeFuture;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setCloseAndCleanupAllDataFuture(CompletableFuture<Void> closeAndCleanupAllDataFuture) {
        this.closeAndCleanupAllDataFuture = closeAndCleanupAllDataFuture;
        return this;
    }
}

