/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.scheduler.SchedulerBase;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorResource;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class PointwisePatternTest {
    @ClassRule
    public static final TestExecutorResource<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorResource();

    @Test
    public void testNToN() throws Exception {
        int N = 23;
        ExecutionJobVertex target = this.setUpExecutionGraphAndGetDownstreamVertex(23, 23);
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ConsumedPartitionGroup consumedPartitionGroup = ev.getConsumedPartitionGroup(0);
            Assert.assertEquals((long)1L, (long)consumedPartitionGroup.size());
            Assert.assertEquals((long)ev.getParallelSubtaskIndex(), (long)consumedPartitionGroup.getFirst().getPartitionNumber());
        }
    }

    @Test
    public void test2NToN() throws Exception {
        int N = 17;
        ExecutionJobVertex target = this.setUpExecutionGraphAndGetDownstreamVertex(34, 17);
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ConsumedPartitionGroup consumedPartitionGroup = ev.getConsumedPartitionGroup(0);
            Assert.assertEquals((long)2L, (long)consumedPartitionGroup.size());
            int idx = 0;
            for (IntermediateResultPartitionID partitionId : consumedPartitionGroup) {
                Assert.assertEquals((long)((long)ev.getParallelSubtaskIndex() * 2L + (long)idx++), (long)partitionId.getPartitionNumber());
            }
        }
    }

    @Test
    public void test3NToN() throws Exception {
        int N = 17;
        ExecutionJobVertex target = this.setUpExecutionGraphAndGetDownstreamVertex(51, 17);
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ConsumedPartitionGroup consumedPartitionGroup = ev.getConsumedPartitionGroup(0);
            Assert.assertEquals((long)3L, (long)consumedPartitionGroup.size());
            int idx = 0;
            for (IntermediateResultPartitionID partitionId : consumedPartitionGroup) {
                Assert.assertEquals((long)((long)ev.getParallelSubtaskIndex() * 3L + (long)idx++), (long)partitionId.getPartitionNumber());
            }
        }
    }

    @Test
    public void testNTo2N() throws Exception {
        int N = 41;
        ExecutionJobVertex target = this.setUpExecutionGraphAndGetDownstreamVertex(41, 82);
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ConsumedPartitionGroup consumedPartitionGroup = ev.getConsumedPartitionGroup(0);
            Assert.assertEquals((long)1L, (long)consumedPartitionGroup.size());
            Assert.assertEquals((long)(ev.getParallelSubtaskIndex() / 2), (long)consumedPartitionGroup.getFirst().getPartitionNumber());
        }
    }

    @Test
    public void testNTo7N() throws Exception {
        int N = 11;
        ExecutionJobVertex target = this.setUpExecutionGraphAndGetDownstreamVertex(11, 77);
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ConsumedPartitionGroup consumedPartitionGroup = ev.getConsumedPartitionGroup(0);
            Assert.assertEquals((long)1L, (long)consumedPartitionGroup.size());
            Assert.assertEquals((long)(ev.getParallelSubtaskIndex() / 7), (long)consumedPartitionGroup.getFirst().getPartitionNumber());
        }
    }

    @Test
    public void testLowHighIrregular() throws Exception {
        this.testLowToHigh(3, 16);
        this.testLowToHigh(19, 21);
        this.testLowToHigh(15, 20);
        this.testLowToHigh(11, 31);
        this.testLowToHigh(11, 29);
    }

    @Test
    public void testHighLowIrregular() throws Exception {
        this.testHighToLow(16, 3);
        this.testHighToLow(21, 19);
        this.testHighToLow(20, 15);
        this.testHighToLow(31, 11);
    }

    @Test
    public void testPointwiseConnectionSequence() throws Exception {
        this.testConnections(3, 5, new int[][]{{0}, {0}, {1}, {1}, {2}});
        this.testConnections(3, 10, new int[][]{{0}, {0}, {0}, {0}, {1}, {1}, {1}, {2}, {2}, {2}});
        this.testConnections(4, 6, new int[][]{{0}, {0}, {1}, {2}, {2}, {3}});
        this.testConnections(6, 10, new int[][]{{0}, {0}, {1}, {1}, {2}, {3}, {3}, {4}, {4}, {5}});
        this.testConnections(5, 3, new int[][]{{0}, {1, 2}, {3, 4}});
        this.testConnections(10, 3, new int[][]{{0, 1, 2}, {3, 4, 5}, {6, 7, 8, 9}});
        this.testConnections(6, 4, new int[][]{{0}, {1, 2}, {3}, {4, 5}});
        this.testConnections(10, 6, new int[][]{{0}, {1, 2}, {3, 4}, {5}, {6, 7}, {8, 9}});
    }

    private void testLowToHigh(int lowDop, int highDop) throws Exception {
        if (highDop < lowDop) {
            throw new IllegalArgumentException();
        }
        int factor = highDop / lowDop;
        int delta = highDop % lowDop == 0 ? 0 : 1;
        ExecutionJobVertex target = this.setUpExecutionGraphAndGetDownstreamVertex(lowDop, highDop);
        int[] timesUsed = new int[lowDop];
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ConsumedPartitionGroup consumedPartitionGroup = ev.getConsumedPartitionGroup(0);
            Assert.assertEquals((long)1L, (long)consumedPartitionGroup.size());
            int n = consumedPartitionGroup.getFirst().getPartitionNumber();
            timesUsed[n] = timesUsed[n] + 1;
        }
        for (int used : timesUsed) {
            Assert.assertTrue((used >= factor && used <= factor + delta ? 1 : 0) != 0);
        }
    }

    private void testHighToLow(int highDop, int lowDop) throws Exception {
        if (highDop < lowDop) {
            throw new IllegalArgumentException();
        }
        int factor = highDop / lowDop;
        int delta = highDop % lowDop == 0 ? 0 : 1;
        ExecutionJobVertex target = this.setUpExecutionGraphAndGetDownstreamVertex(highDop, lowDop);
        int[] timesUsed = new int[highDop];
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ArrayList<IntermediateResultPartitionID> consumedPartitions = new ArrayList<IntermediateResultPartitionID>();
            for (ConsumedPartitionGroup partitionGroup : ev.getAllConsumedPartitionGroups()) {
                for (IntermediateResultPartitionID partitionId : partitionGroup) {
                    consumedPartitions.add(partitionId);
                }
            }
            Assert.assertTrue((consumedPartitions.size() >= factor && consumedPartitions.size() <= factor + delta ? 1 : 0) != 0);
            for (IntermediateResultPartitionID consumedPartition : consumedPartitions) {
                int n = consumedPartition.getPartitionNumber();
                timesUsed[n] = timesUsed[n] + 1;
            }
        }
        for (int used : timesUsed) {
            Assert.assertEquals((long)1L, (long)used);
        }
    }

    private ExecutionJobVertex setUpExecutionGraphAndGetDownstreamVertex(int upstream, int downstream) throws Exception {
        JobVertex v1 = new JobVertex("vertex1");
        JobVertex v2 = new JobVertex("vertex2");
        v1.setParallelism(upstream);
        v2.setParallelism(downstream);
        v1.setInvokableClass(AbstractInvokable.class);
        v2.setInvokableClass(AbstractInvokable.class);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2));
        DefaultExecutionGraph eg = TestingDefaultExecutionGraphBuilder.newBuilder().setVertexParallelismStore(SchedulerBase.computeVertexParallelismStore(ordered)).build((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor());
        try {
            eg.attachJobGraph(ordered);
        }
        catch (JobException e) {
            e.printStackTrace();
            Assert.fail((String)("Job failed with exception: " + e.getMessage()));
        }
        return (ExecutionJobVertex)eg.getAllVertices().get(v2.getID());
    }

    private void testConnections(int sourceParallelism, int targetParallelism, int[][] expectedConsumedPartitionNumber) throws Exception {
        ExecutionJobVertex target = this.setUpExecutionGraphAndGetDownstreamVertex(sourceParallelism, targetParallelism);
        for (int vertexIndex = 0; vertexIndex < target.getTaskVertices().length; ++vertexIndex) {
            ExecutionVertex ev = target.getTaskVertices()[vertexIndex];
            ConsumedPartitionGroup consumedPartitionGroup = ev.getConsumedPartitionGroup(0);
            Assert.assertEquals((long)expectedConsumedPartitionNumber[vertexIndex].length, (long)consumedPartitionGroup.size());
            int partitionIndex = 0;
            for (IntermediateResultPartitionID partitionId : consumedPartitionGroup) {
                Assert.assertEquals((long)expectedConsumedPartitionNumber[vertexIndex][partitionIndex++], (long)partitionId.getPartitionNumber());
            }
        }
    }
}

