/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.client.ClientUtils;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ClientUtilsTest
extends TestLogger {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static BlobServer blobServer = null;

    @BeforeClass
    public static void setup() throws IOException {
        Configuration config = new Configuration();
        blobServer = new BlobServer(config, temporaryFolder.newFolder(), (BlobStore)new VoidBlobStore());
        blobServer.start();
    }

    @AfterClass
    public static void teardown() throws IOException {
        if (blobServer != null) {
            blobServer.close();
        }
    }

    @Test
    public void uploadAndSetUserJars() throws Exception {
        java.nio.file.Path tmpDir = temporaryFolder.newFolder().toPath();
        JobGraph jobGraph = JobGraphTestUtils.emptyJobGraph();
        List<Path> jars = Arrays.asList(new Path(Files.createFile(tmpDir.resolve("jar1.jar"), new FileAttribute[0]).toString()), new Path(Files.createFile(tmpDir.resolve("jar2.jar"), new FileAttribute[0]).toString()));
        jars.forEach(arg_0 -> ((JobGraph)jobGraph).addJar(arg_0));
        Assert.assertEquals((long)jars.size(), (long)jobGraph.getUserJars().size());
        Assert.assertEquals((long)0L, (long)jobGraph.getUserJarBlobKeys().size());
        ClientUtils.extractAndUploadJobGraphFiles((JobGraph)jobGraph, () -> new BlobClient(new InetSocketAddress("localhost", blobServer.getPort()), new Configuration()));
        Assert.assertEquals((long)jars.size(), (long)jobGraph.getUserJars().size());
        Assert.assertEquals((long)jars.size(), (long)jobGraph.getUserJarBlobKeys().size());
        Assert.assertEquals((long)jars.size(), (long)jobGraph.getUserJarBlobKeys().stream().distinct().count());
        for (PermanentBlobKey blobKey : jobGraph.getUserJarBlobKeys()) {
            blobServer.getFile(jobGraph.getJobID(), blobKey);
        }
    }

    @Test
    public void uploadAndSetUserArtifacts() throws Exception {
        java.nio.file.Path tmpDir = temporaryFolder.newFolder().toPath();
        JobGraph jobGraph = JobGraphTestUtils.emptyJobGraph();
        List<DistributedCache.DistributedCacheEntry> localArtifacts = Arrays.asList(new DistributedCache.DistributedCacheEntry(Files.createFile(tmpDir.resolve("art1"), new FileAttribute[0]).toString(), true, true), new DistributedCache.DistributedCacheEntry(Files.createFile(tmpDir.resolve("art2"), new FileAttribute[0]).toString(), true, false), new DistributedCache.DistributedCacheEntry(Files.createFile(tmpDir.resolve("art3"), new FileAttribute[0]).toString(), false, true), new DistributedCache.DistributedCacheEntry(Files.createFile(tmpDir.resolve("art4"), new FileAttribute[0]).toString(), true, false));
        List<DistributedCache.DistributedCacheEntry> distributedArtifacts = Arrays.asList(new DistributedCache.DistributedCacheEntry("hdfs://localhost:1234/test", true, false));
        for (DistributedCache.DistributedCacheEntry entry2 : localArtifacts) {
            jobGraph.addUserArtifact(entry2.filePath, entry2);
        }
        for (DistributedCache.DistributedCacheEntry entry2 : distributedArtifacts) {
            jobGraph.addUserArtifact(entry2.filePath, entry2);
        }
        int totalNumArtifacts = localArtifacts.size() + distributedArtifacts.size();
        Assert.assertEquals((long)totalNumArtifacts, (long)jobGraph.getUserArtifacts().size());
        Assert.assertEquals((long)0L, (long)jobGraph.getUserArtifacts().values().stream().filter(entry -> entry.blobKey != null).count());
        ClientUtils.extractAndUploadJobGraphFiles((JobGraph)jobGraph, () -> new BlobClient(new InetSocketAddress("localhost", blobServer.getPort()), new Configuration()));
        Assert.assertEquals((long)totalNumArtifacts, (long)jobGraph.getUserArtifacts().size());
        Assert.assertEquals((long)localArtifacts.size(), (long)jobGraph.getUserArtifacts().values().stream().filter(entry -> entry.blobKey != null).count());
        Assert.assertEquals((long)distributedArtifacts.size(), (long)jobGraph.getUserArtifacts().values().stream().filter(entry -> entry.blobKey == null).count());
        Assert.assertEquals((long)(localArtifacts.size() + 1), (long)jobGraph.getUserArtifacts().values().stream().map(entry -> entry.blobKey).distinct().count());
        for (DistributedCache.DistributedCacheEntry original : localArtifacts) {
            ClientUtilsTest.assertState(original, (DistributedCache.DistributedCacheEntry)jobGraph.getUserArtifacts().get(original.filePath), false, jobGraph.getJobID());
        }
        for (DistributedCache.DistributedCacheEntry original : distributedArtifacts) {
            ClientUtilsTest.assertState(original, (DistributedCache.DistributedCacheEntry)jobGraph.getUserArtifacts().get(original.filePath), true, jobGraph.getJobID());
        }
    }

    private static void assertState(DistributedCache.DistributedCacheEntry original, DistributedCache.DistributedCacheEntry actual, boolean isBlobKeyNull, JobID jobId) throws Exception {
        Assert.assertEquals((Object)original.isZipped, (Object)actual.isZipped);
        Assert.assertEquals((Object)original.isExecutable, (Object)actual.isExecutable);
        Assert.assertEquals((Object)original.filePath, (Object)actual.filePath);
        Assert.assertEquals((Object)isBlobKeyNull, (Object)(actual.blobKey == null ? 1 : 0));
        if (!isBlobKeyNull) {
            blobServer.getFile(jobId, (PermanentBlobKey)InstantiationUtil.deserializeObject((byte[])actual.blobKey, (ClassLoader)ClientUtilsTest.class.getClassLoader()));
        }
    }
}

