/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.persistence.TestingLongStateHandleHelper;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.util.StateHandleStoreUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.RunnableWithException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class StateHandleStoreUtilsTest
extends TestLogger {
    @Test
    public void testSerializationAndDeserialization() throws Exception {
        TestingLongStateHandleHelper.LongStateHandle original = new TestingLongStateHandleHelper.LongStateHandle(42L);
        byte[] serializedData = StateHandleStoreUtils.serializeOrDiscard((StateObject)original);
        TestingLongStateHandleHelper.LongStateHandle deserializedInstance = (TestingLongStateHandleHelper.LongStateHandle)((Object)StateHandleStoreUtils.deserialize((byte[])serializedData));
        Assert.assertThat((Object)deserializedInstance.getStateSize(), (Matcher)CoreMatchers.is((Object)original.getStateSize()));
        Assert.assertThat((Object)deserializedInstance.getValue(), (Matcher)CoreMatchers.is((Object)original.getValue()));
    }

    @Test
    public void testSerializeOrDiscardFailureHandling() throws Exception {
        AtomicBoolean discardCalled = new AtomicBoolean(false);
        FailingSerializationStateObject original = new FailingSerializationStateObject(() -> discardCalled.set(true));
        try {
            StateHandleStoreUtils.serializeOrDiscard((StateObject)original);
            Assert.fail((String)"An IOException is expected to be thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertThat((Object)discardCalled.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSerializationOrDiscardWithDiscardFailure() throws Exception {
        IllegalStateException discardException = new IllegalStateException("Expected IllegalStateException that should be suppressed.");
        FailingSerializationStateObject original = new FailingSerializationStateObject(() -> {
            throw discardException;
        });
        try {
            StateHandleStoreUtils.serializeOrDiscard((StateObject)original);
            Assert.fail((String)"An IOException is expected to be thrown.");
        }
        catch (IOException e) {
            Assert.assertThat((Object)e.getSuppressed().length, (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)e.getSuppressed()[0], (Matcher)CoreMatchers.is((Object)discardException));
        }
    }

    private static class FailingSerializationStateObject
    implements StateObject {
        private static final long serialVersionUID = 6382458109061973983L;
        private final RunnableWithException discardStateRunnable;

        public FailingSerializationStateObject(RunnableWithException discardStateRunnable) {
            this.discardStateRunnable = discardStateRunnable;
        }

        private void writeObject(ObjectOutputStream outputStream) throws IOException {
            throw new IOException("Expected IOException to test serialization error.");
        }

        public void discardState() throws Exception {
            this.discardStateRunnable.run();
        }

        public long getStateSize() {
            return 0L;
        }
    }
}

