/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import java.time.Duration;
import junit.framework.TestCase;
import org.apache.flink.runtime.throughput.ThroughputCalculator;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ThroughputCalculatorTest
extends TestCase {
    @Test
    public void testCorrectThroughputCalculation() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock, 10);
        throughputCalculator.incomingDataSize(6666L);
        clock.advanceTime(Duration.ofMillis(1L));
        throughputCalculator.incomingDataSize(3333L);
        clock.advanceTime(Duration.ofMillis(33L));
        throughputCalculator.incomingDataSize(1L);
        clock.advanceTime(Duration.ofMillis(66L));
        MatcherAssert.assertThat((Object)throughputCalculator.calculateThroughput(), (Matcher)Matchers.is((Object)100000L));
    }

    @Test
    public void testResetValueAfterCalculation() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock, 10);
        throughputCalculator.incomingDataSize(666L);
        clock.advanceTime(Duration.ofMillis(100L));
        MatcherAssert.assertThat((Object)throughputCalculator.calculateThroughput(), (Matcher)Matchers.is((Object)6660L));
        MatcherAssert.assertThat((Object)throughputCalculator.calculateThroughput(), (Matcher)Matchers.is((Object)6660L));
        clock.advanceTime(Duration.ofMillis(1L));
        MatcherAssert.assertThat((Object)throughputCalculator.calculateThroughput(), (Matcher)Matchers.is((Object)5449L));
    }

    @Test
    public void testIgnoringIdleTime() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock, 10);
        throughputCalculator.incomingDataSize(7L);
        clock.advanceTime(Duration.ofMillis(1L));
        throughputCalculator.pauseMeasurement(clock.absoluteTimeMillis());
        clock.advanceTime(Duration.ofMillis(9L));
        throughputCalculator.incomingDataSize(3L);
        clock.advanceTime(Duration.ofMillis(1L));
        MatcherAssert.assertThat((Object)throughputCalculator.calculateThroughput(), (Matcher)Matchers.is((Object)5000L));
    }

    @Test
    public void testCalculationDuringIdleTime() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock, 10);
        throughputCalculator.incomingDataSize(10L);
        clock.advanceTime(Duration.ofMillis(1L));
        throughputCalculator.pauseMeasurement(clock.absoluteTimeMillis());
        clock.advanceTime(Duration.ofMillis(9L));
        MatcherAssert.assertThat((Object)throughputCalculator.calculateThroughput(), (Matcher)Matchers.is((Object)10000L));
    }

    @Test
    public void testMultiplyIdleEnd() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock, 10);
        throughputCalculator.incomingDataSize(10L);
        clock.advanceTime(Duration.ofMillis(3L));
        throughputCalculator.resumeMeasurement(clock.absoluteTimeMillis());
        clock.advanceTime(Duration.ofMillis(3L));
        throughputCalculator.resumeMeasurement(clock.absoluteTimeMillis());
        clock.advanceTime(Duration.ofMillis(3L));
        throughputCalculator.resumeMeasurement(clock.absoluteTimeMillis());
        clock.advanceTime(Duration.ofMillis(1L));
        MatcherAssert.assertThat((Object)throughputCalculator.calculateThroughput(), (Matcher)Matchers.is((Object)1000L));
    }

    @Test
    public void testNotRestartTimerOnCalculationDuringIdleTime() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock, 10);
        throughputCalculator.pauseMeasurement(clock.absoluteTimeMillis());
        throughputCalculator.calculateThroughput();
        clock.advanceTime(Duration.ofMillis(9L));
        throughputCalculator.incomingDataSize(10L);
        clock.advanceTime(Duration.ofMillis(1L));
        MatcherAssert.assertThat((Object)throughputCalculator.calculateThroughput(), (Matcher)Matchers.is((Object)10000L));
    }
}

