/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.LogicalScopeProvider;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class InMemoryReporter
implements MetricReporter {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryReporter.class);
    private static final String ID = "ID";
    private static final Map<UUID, InMemoryReporter> REPORTERS = new ConcurrentHashMap<UUID, InMemoryReporter>();
    private final Map<MetricGroup, Map<String, Metric>> metrics = new HashMap<MetricGroup, Map<String, Metric>>();
    private final UUID id;
    private final boolean retainMetrics;

    InMemoryReporter(boolean retainMetrics) {
        this.retainMetrics = retainMetrics;
        this.id = UUID.randomUUID();
        REPORTERS.put(this.id, this);
    }

    public static InMemoryReporter create() {
        return new InMemoryReporter(false);
    }

    public static InMemoryReporter createWithRetainedMetrics() {
        return new InMemoryReporter(true);
    }

    public void open(MetricConfig config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            this.metrics.clear();
            REPORTERS.remove(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Metric> getMetricsByIdentifiers() {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.getMetricStream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<MetricGroup, Map<String, Metric>> getMetricsByGroup() {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.metrics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashMap((Map)e.getValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Metric> getMetricsByGroup(MetricGroup metricGroup) {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return new HashMap<String, Metric>(this.metrics.getOrDefault(metricGroup, Collections.emptyMap()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Metric> findMetrics(String identifierPattern) {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.getMetricStream(identifierPattern).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Metric> findMetric(String patternString) {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.getMetricStream(patternString).map(Map.Entry::getValue).findFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MetricGroup> findGroups(String groupPattern) {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.getGroupStream(groupPattern).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<MetricGroup> findGroup(String groupPattern) {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.getGroupStream(groupPattern).findFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OperatorMetricGroup> findOperatorMetricGroups(String operatorPattern) {
        Pattern pattern = Pattern.compile(operatorPattern);
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.metrics.keySet().stream().filter(g -> g instanceof OperatorMetricGroup && pattern.matcher(this.getOperatorName((MetricGroup)g)).find()).map(OperatorMetricGroup.class::cast).sorted(Comparator.comparing(this::getSubtaskId)).collect(Collectors.toList());
        }
    }

    private String getSubtaskId(OperatorMetricGroup g) {
        return g.getScopeComponents()[g.getScopeComponents().length - 1];
    }

    private String getOperatorName(MetricGroup g) {
        return g.getScopeComponents()[g.getScopeComponents().length - 2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        MetricGroup metricGroup = this.unwrap(group);
        LOG.debug("Registered {} @ {}", (Object)metricName, (Object)metricGroup);
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            this.metrics.computeIfAbsent(metricGroup, dummy -> new HashMap()).put(metricName, metric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        if (!this.retainMetrics) {
            InMemoryReporter inMemoryReporter = this;
            synchronized (inMemoryReporter) {
                MetricGroup metricGroup = this.unwrap(group);
                Map<String, Metric> registeredMetrics = this.metrics.get(metricGroup);
                if (registeredMetrics != null) {
                    registeredMetrics.remove(metricName);
                    if (registeredMetrics.isEmpty()) {
                        this.metrics.remove(metricGroup);
                    }
                }
            }
        }
    }

    private Stream<Map.Entry<String, Metric>> getMetricStream(String identifierPattern) {
        Pattern pattern = Pattern.compile(identifierPattern);
        return this.getMetricStream().filter(m -> pattern.matcher((CharSequence)m.getKey()).find());
    }

    private Stream<Map.Entry<String, Metric>> getMetricStream() {
        return this.metrics.entrySet().stream().flatMap(this::getGroupMetricStream);
    }

    private Stream<MetricGroup> getGroupStream(String groupPattern) {
        Pattern pattern = Pattern.compile(groupPattern);
        return this.metrics.keySet().stream().filter(group -> Arrays.stream(group.getScopeComponents()).anyMatch(scope -> pattern.matcher((CharSequence)scope).find()));
    }

    private Stream<AbstractMap.SimpleEntry<String, Metric>> getGroupMetricStream(Map.Entry<MetricGroup, Map<String, Metric>> groupMetrics) {
        return groupMetrics.getValue().entrySet().stream().map(nameMetric -> new AbstractMap.SimpleEntry(((MetricGroup)groupMetrics.getKey()).getMetricIdentifier((String)nameMetric.getKey()), nameMetric.getValue()));
    }

    private MetricGroup unwrap(MetricGroup group) {
        return group instanceof LogicalScopeProvider ? ((LogicalScopeProvider)group).getWrappedMetricGroup() : group;
    }

    public void addToConfiguration(Configuration configuration) {
        configuration.setString("metrics.reporter.mini_cluster_resource_reporter.factory.class", Factory.class.getName());
        configuration.setString("metrics.reporter.mini_cluster_resource_reporter.ID", this.id.toString());
    }

    public static class Factory
    implements MetricReporterFactory {
        public MetricReporter createMetricReporter(Properties properties) {
            String id = properties.getProperty(InMemoryReporter.ID);
            Preconditions.checkState((id != null ? 1 : 0) != 0, (Object)"Reporter id not found. Did you use InMemoryReporter#addConfiguration?");
            return (MetricReporter)REPORTERS.get(UUID.fromString(id));
        }
    }
}

