/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.junit.Assert;
import org.junit.Test;

public class LatencyTrackingStateConfigTest {
    @Test
    public void testDefaultDisabledLatencyTrackingStateConfig() {
        LatencyTrackingStateConfig latencyTrackingStateConfig = LatencyTrackingStateConfig.newBuilder().build();
        Assert.assertFalse((boolean)latencyTrackingStateConfig.isEnabled());
    }

    @Test
    public void testDefaultEnabledLatencyTrackingStateConfig() {
        UnregisteredMetricsGroup metricsGroup = new UnregisteredMetricsGroup();
        LatencyTrackingStateConfig latencyTrackingStateConfig = LatencyTrackingStateConfig.newBuilder().setEnabled(true).setMetricGroup((MetricGroup)metricsGroup).build();
        Assert.assertTrue((boolean)latencyTrackingStateConfig.isEnabled());
        Assert.assertEquals((long)((Integer)StateBackendOptions.LATENCY_TRACK_SAMPLE_INTERVAL.defaultValue()).intValue(), (long)latencyTrackingStateConfig.getSampleInterval());
        Assert.assertEquals((long)((Integer)StateBackendOptions.LATENCY_TRACK_HISTORY_SIZE.defaultValue()).intValue(), (long)latencyTrackingStateConfig.getHistorySize());
    }

    @Test
    public void testSetLatencyTrackingStateConfig() {
        UnregisteredMetricsGroup metricsGroup = new UnregisteredMetricsGroup();
        LatencyTrackingStateConfig latencyTrackingStateConfig = LatencyTrackingStateConfig.newBuilder().setMetricGroup((MetricGroup)metricsGroup).setEnabled(true).setSampleInterval(10).setHistorySize(500).build();
        Assert.assertTrue((boolean)latencyTrackingStateConfig.isEnabled());
        Assert.assertEquals((long)10L, (long)latencyTrackingStateConfig.getSampleInterval());
        Assert.assertEquals((long)500L, (long)latencyTrackingStateConfig.getHistorySize());
    }

    @Test
    public void testConfigureFromReadableConfig() {
        LatencyTrackingStateConfig.Builder builder = LatencyTrackingStateConfig.newBuilder();
        Configuration configuration = new Configuration();
        configuration.setBoolean(StateBackendOptions.LATENCY_TRACK_ENABLED, true);
        configuration.setInteger(StateBackendOptions.LATENCY_TRACK_SAMPLE_INTERVAL, 10);
        configuration.setInteger(StateBackendOptions.LATENCY_TRACK_HISTORY_SIZE, 500);
        LatencyTrackingStateConfig latencyTrackingStateConfig = builder.configure((ReadableConfig)configuration).setMetricGroup((MetricGroup)new UnregisteredMetricsGroup()).build();
        Assert.assertTrue((boolean)latencyTrackingStateConfig.isEnabled());
        Assert.assertEquals((long)10L, (long)latencyTrackingStateConfig.getSampleInterval());
        Assert.assertEquals((long)500L, (long)latencyTrackingStateConfig.getHistorySize());
    }
}

