/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.metrics.LatencyTrackingMapState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateTestBase;
import org.junit.Assert;
import org.junit.Test;

public class LatencyTrackingMapStateTest
extends LatencyTrackingStateTestBase<Integer> {
    @Override
    MapStateDescriptor<Integer, Double> getStateDescriptor() {
        return new MapStateDescriptor("map", Integer.class, Double.class);
    }

    @Override
    TypeSerializer<Integer> getKeySerializer() {
        return IntSerializer.INSTANCE;
    }

    @Override
    void setCurrentKey(AbstractKeyedStateBackend<Integer> keyedBackend) {
        keyedBackend.setCurrentKey((Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLatencyTrackingMapState() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            LatencyTrackingMapState latencyTrackingState = (LatencyTrackingMapState)this.createLatencyTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            LatencyTrackingMapState.MapStateLatencyMetrics latencyTrackingStateMetric = (LatencyTrackingMapState.MapStateLatencyMetrics)latencyTrackingState.getLatencyTrackingStateMetric();
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getContainsCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getEntriesInitCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getGetCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getIsEmptyCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getIteratorInitCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getIteratorHasNextCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getIteratorNextCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getKeysInitCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getValuesInitCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getIteratorRemoveCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getPutAllCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getPutCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getRemoveCount());
            this.setCurrentKey(keyedBackend);
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                latencyTrackingState.put((Object)random.nextLong(), (Object)random.nextDouble());
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getPutCount());
                latencyTrackingState.putAll(Collections.singletonMap(random.nextLong(), random.nextDouble()));
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getPutAllCount());
                latencyTrackingState.get((Object)random.nextLong());
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getGetCount());
                latencyTrackingState.remove((Object)random.nextLong());
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getRemoveCount());
                latencyTrackingState.contains((Object)random.nextLong());
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getContainsCount());
                latencyTrackingState.isEmpty();
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getIsEmptyCount());
                latencyTrackingState.entries();
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getEntriesInitCount());
                latencyTrackingState.keys();
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getKeysInitCount());
                latencyTrackingState.values();
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getValuesInitCount());
                latencyTrackingState.iterator();
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getIteratorInitCount());
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLatencyTrackingMapStateIterator() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            LatencyTrackingMapState latencyTrackingState = (LatencyTrackingMapState)this.createLatencyTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            LatencyTrackingMapState.MapStateLatencyMetrics latencyTrackingStateMetric = (LatencyTrackingMapState.MapStateLatencyMetrics)latencyTrackingState.getLatencyTrackingStateMetric();
            this.setCurrentKey(keyedBackend);
            this.verifyIterator((LatencyTrackingMapState<Integer, VoidNamespace, Long, Double>)latencyTrackingState, latencyTrackingStateMetric, latencyTrackingState.iterator(), true);
            this.verifyIterator((LatencyTrackingMapState<Integer, VoidNamespace, Long, Double>)latencyTrackingState, latencyTrackingStateMetric, latencyTrackingState.entries().iterator(), true);
            this.verifyIterator((LatencyTrackingMapState<Integer, VoidNamespace, Long, Double>)latencyTrackingState, latencyTrackingStateMetric, latencyTrackingState.keys().iterator(), false);
            this.verifyIterator((LatencyTrackingMapState<Integer, VoidNamespace, Long, Double>)latencyTrackingState, latencyTrackingStateMetric, latencyTrackingState.values().iterator(), false);
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }

    private <E> void verifyIterator(LatencyTrackingMapState<Integer, VoidNamespace, Long, Double> latencyTrackingState, LatencyTrackingMapState.MapStateLatencyMetrics latencyTrackingStateMetric, Iterator<E> iterator, boolean removeIterator) throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int index = 1; index <= 10; ++index) {
            latencyTrackingState.put((Object)index, (Object)random.nextDouble());
        }
        int count = 1;
        while (iterator.hasNext()) {
            int expectedResult = count == 10 ? 0 : count;
            Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getIteratorHasNextCount());
            iterator.next();
            Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getIteratorNextCount());
            if (removeIterator) {
                iterator.remove();
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getIteratorRemoveCount());
            }
            ++count;
        }
        latencyTrackingStateMetric.resetIteratorHasNextCount();
        latencyTrackingState.clear();
    }
}

