/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.RunnableFuture;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.heap.HeapStateBackendTestBase;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Test;

public class HeapKeyedStateBackendSnapshotMigrationTest
extends HeapStateBackendTestBase {
    @Test
    public void testMapStateMigrationAfterHashMapSerRemoval() throws Exception {
        SnapshotResult stateHandles;
        ClassLoader cl = this.getClass().getClassLoader();
        URL resource = cl.getResource("heap_keyed_statebackend_1_5_map.snapshot");
        Preconditions.checkNotNull((Object)resource, (String)"Binary snapshot resource not found!");
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(resource.getFile()));){
            stateHandles = (SnapshotResult)InstantiationUtil.deserializeObject((InputStream)bis, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        KeyedStateHandle stateHandle = (KeyedStateHandle)stateHandles.getJobManagerOwnedSnapshot();
        try (HeapKeyedStateBackend<String> keyedBackend = this.createKeyedBackend((Collection<KeyedStateHandle>)StateObjectCollection.singleton((StateObject)stateHandle));){
            Integer namespace1 = 1;
            Integer namespace2 = 2;
            Integer namespace3 = 3;
            MapStateDescriptor stateDescr = new MapStateDescriptor("my-map-state", Long.class, Long.class);
            stateDescr.initializeSerializerUnlessSet(new ExecutionConfig());
            InternalMapState state = (InternalMapState)keyedBackend.createInternalState((TypeSerializer)IntSerializer.INSTANCE, (StateDescriptor)stateDescr);
            keyedBackend.setCurrentKey((Object)"abc");
            state.setCurrentNamespace((Object)namespace1);
            Assert.assertEquals((long)33L, (long)((Long)state.get((Object)33L)));
            Assert.assertEquals((long)55L, (long)((Long)state.get((Object)55L)));
            Assert.assertEquals((long)2L, (long)this.getStateSize(state));
            state.setCurrentNamespace((Object)namespace2);
            Assert.assertEquals((long)22L, (long)((Long)state.get((Object)22L)));
            Assert.assertEquals((long)11L, (long)((Long)state.get((Object)11L)));
            Assert.assertEquals((long)2L, (long)this.getStateSize(state));
            state.setCurrentNamespace((Object)namespace3);
            Assert.assertEquals((long)44L, (long)((Long)state.get((Object)44L)));
            Assert.assertEquals((long)1L, (long)this.getStateSize(state));
            keyedBackend.setCurrentKey((Object)"def");
            state.setCurrentNamespace((Object)namespace1);
            Assert.assertEquals((long)11L, (long)((Long)state.get((Object)11L)));
            Assert.assertEquals((long)44L, (long)((Long)state.get((Object)44L)));
            Assert.assertEquals((long)2L, (long)this.getStateSize(state));
            state.setCurrentNamespace((Object)namespace3);
            Assert.assertEquals((long)22L, (long)((Long)state.get((Object)22L)));
            Assert.assertEquals((long)55L, (long)((Long)state.get((Object)55L)));
            Assert.assertEquals((long)33L, (long)((Long)state.get((Object)33L)));
            Assert.assertEquals((long)3L, (long)this.getStateSize(state));
            keyedBackend.setCurrentKey((Object)"jkl");
            state.setCurrentNamespace((Object)namespace1);
            Assert.assertEquals((long)11L, (long)((Long)state.get((Object)11L)));
            Assert.assertEquals((long)22L, (long)((Long)state.get((Object)22L)));
            Assert.assertEquals((long)33L, (long)((Long)state.get((Object)33L)));
            Assert.assertEquals((long)44L, (long)((Long)state.get((Object)44L)));
            Assert.assertEquals((long)55L, (long)((Long)state.get((Object)55L)));
            Assert.assertEquals((long)5L, (long)this.getStateSize(state));
            keyedBackend.setCurrentKey((Object)"mno");
            state.setCurrentNamespace((Object)namespace3);
            Assert.assertEquals((long)11L, (long)((Long)state.get((Object)11L)));
            Assert.assertEquals((long)22L, (long)((Long)state.get((Object)22L)));
            Assert.assertEquals((long)33L, (long)((Long)state.get((Object)33L)));
            Assert.assertEquals((long)44L, (long)((Long)state.get((Object)44L)));
            Assert.assertEquals((long)55L, (long)((Long)state.get((Object)55L)));
            Assert.assertEquals((long)5L, (long)this.getStateSize(state));
            RunnableFuture snapshot = keyedBackend.snapshot(1L, 1L, (CheckpointStreamFactory)new MemCheckpointStreamFactory(0x400000), CheckpointOptions.forCheckpointWithDefaultLocation());
            snapshot.run();
        }
    }

    private <K, N, UK, UV> int getStateSize(InternalMapState<K, N, UK, UV> mapState) throws Exception {
        int i = 0;
        Iterator itt = mapState.iterator();
        while (itt.hasNext()) {
            ++i;
            itt.next();
        }
        return i;
    }
}

