/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.TestingPhysicalSlotPayload;
import org.apache.flink.runtime.scheduler.TestingPhysicalSlot;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SharedSlot;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SharedSlotTest
extends TestLogger {
    @Test
    public void testConstructorAssignsPayload() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        Assert.assertThat((Object)physicalSlot.getPayload(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test(expected=IllegalStateException.class)
    public void testConstructorFailsIfSlotAlreadyHasAssignedPayload() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        physicalSlot.tryAssignPayload(new TestingPhysicalSlotPayload());
        new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
    }

    @Test
    public void testAllocateLogicalSlot() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        LogicalSlot logicalSlot = sharedSlot.allocateLogicalSlot();
        Assert.assertThat((Object)logicalSlot.getAllocationId(), (Matcher)CoreMatchers.equalTo((Object)physicalSlot.getAllocationId()));
        Assert.assertThat((Object)logicalSlot.getLocality(), (Matcher)CoreMatchers.is((Object)Locality.UNKNOWN));
        Assert.assertThat((Object)logicalSlot.getPayload(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)logicalSlot.getTaskManagerLocation(), (Matcher)CoreMatchers.equalTo((Object)physicalSlot.getTaskManagerLocation()));
        Assert.assertThat((Object)logicalSlot.getTaskManagerGateway(), (Matcher)CoreMatchers.equalTo((Object)physicalSlot.getTaskManagerGateway()));
    }

    @Test
    public void testAllocateLogicalSlotIssuesUniqueSlotRequestIds() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        LogicalSlot logicalSlot1 = sharedSlot.allocateLogicalSlot();
        LogicalSlot logicalSlot2 = sharedSlot.allocateLogicalSlot();
        Assert.assertThat((Object)logicalSlot1.getSlotRequestId(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)logicalSlot2.getSlotRequestId())));
    }

    @Test(expected=IllegalStateException.class)
    public void testReturnLogicalSlotRejectsAliveSlots() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        LogicalSlot logicalSlot = sharedSlot.allocateLogicalSlot();
        sharedSlot.returnLogicalSlot(logicalSlot);
    }

    @Test(expected=IllegalStateException.class)
    public void testReturnLogicalSlotRejectsUnknownSlot() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        TestingLogicalSlot logicalSlot = new TestingLogicalSlotBuilder().createTestingLogicalSlot();
        logicalSlot.releaseSlot(new Exception("test"));
        sharedSlot.returnLogicalSlot((LogicalSlot)logicalSlot);
    }

    @Test
    public void testReturnLogicalSlotTriggersExternalReleaseOnLastSlot() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        AtomicBoolean externalReleaseInitiated = new AtomicBoolean(false);
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> externalReleaseInitiated.set(true));
        LogicalSlot logicalSlot1 = sharedSlot.allocateLogicalSlot();
        LogicalSlot logicalSlot2 = sharedSlot.allocateLogicalSlot();
        logicalSlot1.releaseSlot((Throwable)new Exception("test"));
        Assert.assertThat((Object)externalReleaseInitiated.get(), (Matcher)CoreMatchers.is((Object)false));
        logicalSlot2.releaseSlot((Throwable)new Exception("test"));
        Assert.assertThat((Object)externalReleaseInitiated.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testReleaseDoesNotTriggersExternalRelease() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        AtomicBoolean externalReleaseInitiated = new AtomicBoolean(false);
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> externalReleaseInitiated.set(true));
        sharedSlot.release((Throwable)new Exception("test"));
        Assert.assertThat((Object)externalReleaseInitiated.get(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testReleaseAlsoReleasesLogicalSlots() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        LogicalSlot logicalSlot = sharedSlot.allocateLogicalSlot();
        sharedSlot.release((Throwable)new Exception("test"));
        Assert.assertThat((Object)logicalSlot.isAlive(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=IllegalStateException.class)
    public void testReleaseForbidsSubsequentLogicalSlotAllocations() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        sharedSlot.release((Throwable)new Exception("test"));
        sharedSlot.allocateLogicalSlot();
    }

    @Test
    public void testCanReturnLogicalSlotDuringRelease() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        LogicalSlot logicalSlot1 = sharedSlot.allocateLogicalSlot();
        LogicalSlot logicalSlot2 = sharedSlot.allocateLogicalSlot();
        logicalSlot1.tryAssignPayload((LogicalSlot.Payload)new TestLogicalSlotPayload(cause -> {
            if (logicalSlot2.isAlive()) {
                logicalSlot2.releaseSlot(cause);
            }
        }));
        logicalSlot2.tryAssignPayload((LogicalSlot.Payload)new TestLogicalSlotPayload(cause -> {
            if (logicalSlot1.isAlive()) {
                logicalSlot1.releaseSlot(cause);
            }
        }));
        sharedSlot.release((Throwable)new Exception("test"));
        Assert.assertThat((Object)logicalSlot1.isAlive(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)logicalSlot2.isAlive(), (Matcher)CoreMatchers.is((Object)false));
        try {
            sharedSlot.allocateLogicalSlot();
            Assert.fail((String)"Allocation of logical slot should have failed because the slot was released.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testCannotAllocateLogicalSlotDuringRelease() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        LogicalSlot logicalSlot = sharedSlot.allocateLogicalSlot();
        logicalSlot.tryAssignPayload((LogicalSlot.Payload)new TestLogicalSlotPayload(ignored -> sharedSlot.allocateLogicalSlot()));
        sharedSlot.release((Throwable)new Exception("test"));
    }

    private static class TestLogicalSlotPayload
    implements LogicalSlot.Payload {
        private final Consumer<Throwable> failConsumer;

        public TestLogicalSlotPayload() {
            this.failConsumer = ignored -> {};
        }

        public TestLogicalSlotPayload(Consumer<Throwable> failConsumer) {
            this.failConsumer = failConsumer;
        }

        public void fail(Throwable cause) {
            this.failConsumer.accept(cause);
        }

        public CompletableFuture<?> getTerminalStateFuture() {
            return new CompletableFuture();
        }
    }
}

