/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.rest.messages.MessageParameter;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.MessagePathParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class MessageParametersTest
extends TestLogger {
    @Test
    public void testResolveUrl() {
        String genericUrl = "/jobs/:jobid/state";
        TestMessageParameters parameters = new TestMessageParameters();
        JobID pathJobID = new JobID();
        JobID queryJobID = new JobID();
        parameters.pathParameter.resolve(pathJobID);
        parameters.queryParameter.resolve(Collections.singletonList(queryJobID));
        String resolvedUrl = MessageParameters.resolveUrl((String)genericUrl, (MessageParameters)parameters);
        Assert.assertEquals((Object)("/jobs/" + pathJobID + "/state?jobid=" + queryJobID), (Object)resolvedUrl);
    }

    @Test
    public void testUnresolvedParameters() {
        String genericUrl = "/jobs/:jobid/state";
        TestMessageParameters parameters = new TestMessageParameters();
        try {
            MessageParameters.resolveUrl((String)genericUrl, (MessageParameters)parameters);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        JobID jobID = new JobID();
        parameters.pathParameter.resolve(jobID);
        String resolvedUrl = MessageParameters.resolveUrl((String)genericUrl, (MessageParameters)parameters);
        Assert.assertEquals((Object)("/jobs/" + jobID + "/state"), (Object)resolvedUrl);
    }

    private static class TestQueryParameter
    extends MessageQueryParameter<JobID> {
        TestQueryParameter() {
            super("jobid", MessageParameter.MessageParameterRequisiteness.OPTIONAL);
        }

        public JobID convertStringToValue(String value) {
            return JobID.fromHexString((String)value);
        }

        public String convertValueToString(JobID value) {
            return value.toString();
        }

        public String getDescription() {
            return "query parameter";
        }
    }

    private static class TestPathParameter
    extends MessagePathParameter<JobID> {
        TestPathParameter() {
            super("jobid");
        }

        public JobID convertFromString(String value) {
            return JobID.fromHexString((String)value);
        }

        protected String convertToString(JobID value) {
            return value.toString();
        }

        public String getDescription() {
            return "path parameter";
        }
    }

    private static class TestMessageParameters
    extends MessageParameters {
        private final TestPathParameter pathParameter = new TestPathParameter();
        private final TestQueryParameter queryParameter = new TestQueryParameter();

        private TestMessageParameters() {
        }

        public Collection<MessagePathParameter<?>> getPathParameters() {
            return Collections.singleton(this.pathParameter);
        }

        public Collection<MessageQueryParameter<?>> getQueryParameters() {
            return Collections.singleton(this.queryParameter);
        }
    }
}

