/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceActions;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskExecutorManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceActionsBuilder;
import org.apache.flink.runtime.testutils.TestingUtils;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.concurrent.ScheduledExecutor;

public class TaskExecutorManagerBuilder {
    private WorkerResourceSpec defaultWorkerResourceSpec = new WorkerResourceSpec.Builder().setCpuCores(4.0).build();
    private int numSlotsPerWorker = 1;
    private int maxSlotNum = 1;
    private boolean waitResultConsumedBeforeRelease = true;
    private int redundantTaskManagerNum = 0;
    private Time taskManagerTimeout = Time.seconds((long)5L);
    private ScheduledExecutor scheduledExecutor = TestingUtils.defaultScheduledExecutor();
    private Executor mainThreadExecutor = Executors.directExecutor();
    private ResourceActions newResourceActions = new TestingResourceActionsBuilder().build();

    public TaskExecutorManagerBuilder setDefaultWorkerResourceSpec(WorkerResourceSpec defaultWorkerResourceSpec) {
        this.defaultWorkerResourceSpec = defaultWorkerResourceSpec;
        return this;
    }

    public TaskExecutorManagerBuilder setNumSlotsPerWorker(int numSlotsPerWorker) {
        this.numSlotsPerWorker = numSlotsPerWorker;
        return this;
    }

    public TaskExecutorManagerBuilder setMaxNumSlots(int maxSlotNum) {
        this.maxSlotNum = maxSlotNum;
        return this;
    }

    public TaskExecutorManagerBuilder setWaitResultConsumedBeforeRelease(boolean waitResultConsumedBeforeRelease) {
        this.waitResultConsumedBeforeRelease = waitResultConsumedBeforeRelease;
        return this;
    }

    public TaskExecutorManagerBuilder setRedundantTaskManagerNum(int redundantTaskManagerNum) {
        this.redundantTaskManagerNum = redundantTaskManagerNum;
        return this;
    }

    public TaskExecutorManagerBuilder setTaskManagerTimeout(Time taskManagerTimeout) {
        this.taskManagerTimeout = taskManagerTimeout;
        return this;
    }

    public TaskExecutorManagerBuilder setScheduledExecutor(ScheduledExecutor scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
        return this;
    }

    public TaskExecutorManagerBuilder setMainThreadExecutor(Executor mainThreadExecutor) {
        this.mainThreadExecutor = mainThreadExecutor;
        return this;
    }

    public TaskExecutorManagerBuilder setResourceActions(ResourceActions newResourceActions) {
        this.newResourceActions = newResourceActions;
        return this;
    }

    public TaskExecutorManager createTaskExecutorManager() {
        return new TaskExecutorManager(this.defaultWorkerResourceSpec, this.numSlotsPerWorker, this.maxSlotNum, this.waitResultConsumedBeforeRelease, this.redundantTaskManagerNum, this.taskManagerTimeout, this.scheduledExecutor, this.mainThreadExecutor, this.newResourceActions);
    }
}

