/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.DeclarativeTaskManagerSlot;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultSlotTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.Test;

public class SlotStatusReconcilerTest
extends TestLogger {
    private static final TaskExecutorConnection TASK_EXECUTOR_CONNECTION = new TaskExecutorConnection(ResourceID.generate(), (TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway());

    @Test
    public void testSlotStatusReconciliationForFreeSlot() {
        JobID jobId1 = new JobID();
        StateTransitionTracker stateTransitionTracker = new StateTransitionTracker();
        DefaultSlotTracker.SlotStatusStateReconciler reconciler = SlotStatusReconcilerTest.createSlotStatusReconciler(stateTransitionTracker);
        DeclarativeTaskManagerSlot slot = new DeclarativeTaskManagerSlot(new SlotID(ResourceID.generate(), 0), ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION);
        Assert.assertThat((Object)reconciler.executeStateTransition(slot, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(stateTransitionTracker.stateTransitions, (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)reconciler.executeStateTransition(slot, jobId1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)stateTransitionTracker.stateTransitions.remove(), (Matcher)CoreMatchers.is(SlotStatusReconcilerTest.transitionWithTargetStateForJob(SlotState.PENDING, jobId1)));
        Assert.assertThat((Object)stateTransitionTracker.stateTransitions.remove(), (Matcher)CoreMatchers.is(SlotStatusReconcilerTest.transitionWithTargetStateForJob(SlotState.ALLOCATED, jobId1)));
    }

    @Test
    public void testSlotStatusReconciliationForPendingSlot() {
        JobID jobId1 = new JobID();
        StateTransitionTracker stateTransitionTracker = new StateTransitionTracker();
        DefaultSlotTracker.SlotStatusStateReconciler reconciler = SlotStatusReconcilerTest.createSlotStatusReconciler(stateTransitionTracker);
        DeclarativeTaskManagerSlot slot = new DeclarativeTaskManagerSlot(new SlotID(ResourceID.generate(), 0), ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION);
        slot.startAllocation(jobId1);
        Assert.assertThat((Object)reconciler.executeStateTransition(slot, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(stateTransitionTracker.stateTransitions, (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)reconciler.executeStateTransition(slot, jobId1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)stateTransitionTracker.stateTransitions.remove(), (Matcher)CoreMatchers.is(SlotStatusReconcilerTest.transitionWithTargetStateForJob(SlotState.ALLOCATED, jobId1)));
    }

    @Test
    public void testSlotStatusReconciliationForPendingSlotWithDifferentJobID() {
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        StateTransitionTracker stateTransitionTracker = new StateTransitionTracker();
        DefaultSlotTracker.SlotStatusStateReconciler reconciler = SlotStatusReconcilerTest.createSlotStatusReconciler(stateTransitionTracker);
        DeclarativeTaskManagerSlot slot = new DeclarativeTaskManagerSlot(new SlotID(ResourceID.generate(), 0), ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION);
        slot.startAllocation(jobId1);
        Assert.assertThat((Object)reconciler.executeStateTransition(slot, jobId2), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)stateTransitionTracker.stateTransitions.remove(), (Matcher)CoreMatchers.is(SlotStatusReconcilerTest.transitionWithTargetStateForJob(SlotState.FREE, jobId1)));
        Assert.assertThat((Object)stateTransitionTracker.stateTransitions.remove(), (Matcher)CoreMatchers.is(SlotStatusReconcilerTest.transitionWithTargetStateForJob(SlotState.PENDING, jobId2)));
        Assert.assertThat((Object)stateTransitionTracker.stateTransitions.remove(), (Matcher)CoreMatchers.is(SlotStatusReconcilerTest.transitionWithTargetStateForJob(SlotState.ALLOCATED, jobId2)));
    }

    @Test
    public void testSlotStatusReconciliationForAllocatedSlot() {
        JobID jobId1 = new JobID();
        StateTransitionTracker stateTransitionTracker = new StateTransitionTracker();
        DefaultSlotTracker.SlotStatusStateReconciler reconciler = SlotStatusReconcilerTest.createSlotStatusReconciler(stateTransitionTracker);
        DeclarativeTaskManagerSlot slot = new DeclarativeTaskManagerSlot(new SlotID(ResourceID.generate(), 0), ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION);
        slot.startAllocation(jobId1);
        slot.completeAllocation();
        Assert.assertThat((Object)reconciler.executeStateTransition(slot, jobId1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(stateTransitionTracker.stateTransitions, (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)reconciler.executeStateTransition(slot, null), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)stateTransitionTracker.stateTransitions.remove(), (Matcher)CoreMatchers.is(SlotStatusReconcilerTest.transitionWithTargetStateForJob(SlotState.FREE, jobId1)));
    }

    @Test
    public void testSlotStatusReconciliationForAllocatedSlotWithDifferentJobID() {
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        StateTransitionTracker stateTransitionTracker = new StateTransitionTracker();
        DefaultSlotTracker.SlotStatusStateReconciler reconciler = SlotStatusReconcilerTest.createSlotStatusReconciler(stateTransitionTracker);
        DeclarativeTaskManagerSlot slot = new DeclarativeTaskManagerSlot(new SlotID(ResourceID.generate(), 0), ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION);
        slot.startAllocation(jobId1);
        slot.completeAllocation();
        Assert.assertThat((Object)reconciler.executeStateTransition(slot, jobId2), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)stateTransitionTracker.stateTransitions.remove(), (Matcher)CoreMatchers.is(SlotStatusReconcilerTest.transitionWithTargetStateForJob(SlotState.FREE, jobId1)));
        Assert.assertThat((Object)stateTransitionTracker.stateTransitions.remove(), (Matcher)CoreMatchers.is(SlotStatusReconcilerTest.transitionWithTargetStateForJob(SlotState.PENDING, jobId2)));
        Assert.assertThat((Object)stateTransitionTracker.stateTransitions.remove(), (Matcher)CoreMatchers.is(SlotStatusReconcilerTest.transitionWithTargetStateForJob(SlotState.ALLOCATED, jobId2)));
    }

    private static DefaultSlotTracker.SlotStatusStateReconciler createSlotStatusReconciler(StateTransitionTracker stateTransitionTracker) {
        return new DefaultSlotTracker.SlotStatusStateReconciler(stateTransitionTracker::notifyFree, (jobId, jobId2) -> stateTransitionTracker.notifyPending((JobID)jobId2), (jobId1, jobId12) -> stateTransitionTracker.notifyAllocated((JobID)jobId12));
    }

    private static Matcher<SlotStateTransition> transitionWithTargetStateForJob(SlotState targetState, JobID jobId) {
        return new SlotStateTransitionMatcher(targetState, jobId);
    }

    private static class SlotStateTransitionMatcher
    extends TypeSafeMatcher<SlotStateTransition> {
        private final SlotState targetState;
        private final JobID jobId;

        private SlotStateTransitionMatcher(SlotState targetState, JobID jobId) {
            this.targetState = targetState;
            this.jobId = jobId;
        }

        protected boolean matchesSafely(SlotStateTransition item) {
            return item.newState == this.targetState && this.jobId.equals((Object)item.jobId);
        }

        public void describeTo(Description description) {
            description.appendText("a transition with targetState=").appendValue((Object)this.targetState).appendText(" and jobId=").appendValue((Object)this.jobId);
        }
    }

    private static class SlotStateTransition {
        private final SlotState newState;
        @Nullable
        private final JobID jobId;

        private SlotStateTransition(SlotState newState, @Nullable JobID jobId) {
            this.jobId = jobId;
            this.newState = newState;
        }

        public String toString() {
            return "SlotStateTransition{, newState=" + this.newState + ", jobId=" + this.jobId + '}';
        }
    }

    private static class StateTransitionTracker {
        Queue<SlotStateTransition> stateTransitions = new ArrayDeque<SlotStateTransition>();

        private StateTransitionTracker() {
        }

        void notifyFree(DeclarativeTaskManagerSlot slot) {
            this.stateTransitions.add(new SlotStateTransition(SlotState.FREE, slot.getJobId()));
        }

        void notifyPending(JobID jobId) {
            this.stateTransitions.add(new SlotStateTransition(SlotState.PENDING, jobId));
        }

        void notifyAllocated(JobID jobId) {
            this.stateTransitions.add(new SlotStateTransition(SlotState.ALLOCATED, jobId));
        }
    }
}

