/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.active;

import javax.annotation.Nullable;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.active.ActiveResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.active.ResourceManagerDriver;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ActiveResourceManagerFactoryTest
extends TestLogger {
    private static final MemorySize TOTAL_FLINK_SIZE = MemorySize.ofMebiBytes((long)2048L);
    private static final MemorySize TOTAL_PROCESS_SIZE = MemorySize.ofMebiBytes((long)3072L);

    @Test
    public void testGetEffectiveConfigurationForResourceManagerCoarseGrained() {
        Configuration config = new Configuration();
        config.set(ClusterOptions.ENABLE_FINE_GRAINED_RESOURCE_MANAGEMENT, (Object)false);
        config.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_SIZE);
        config.set(TaskManagerOptions.TOTAL_PROCESS_MEMORY, (Object)TOTAL_PROCESS_SIZE);
        Configuration effectiveConfig = ActiveResourceManagerFactoryTest.getFactory().getEffectiveConfigurationForResourceManager(config);
        Assert.assertTrue((boolean)effectiveConfig.contains(TaskManagerOptions.TOTAL_FLINK_MEMORY));
        Assert.assertTrue((boolean)effectiveConfig.contains(TaskManagerOptions.TOTAL_PROCESS_MEMORY));
        Assert.assertThat((Object)effectiveConfig.get(TaskManagerOptions.TOTAL_FLINK_MEMORY), (Matcher)Matchers.is((Object)TOTAL_FLINK_SIZE));
        Assert.assertThat((Object)effectiveConfig.get(TaskManagerOptions.TOTAL_PROCESS_MEMORY), (Matcher)Matchers.is((Object)TOTAL_PROCESS_SIZE));
    }

    @Test
    public void testGetEffectiveConfigurationForResourceManagerFineGrained() {
        Configuration config = new Configuration();
        config.set(ClusterOptions.ENABLE_FINE_GRAINED_RESOURCE_MANAGEMENT, (Object)true);
        config.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_SIZE);
        config.set(TaskManagerOptions.TOTAL_PROCESS_MEMORY, (Object)TOTAL_PROCESS_SIZE);
        Configuration effectiveConfig = ActiveResourceManagerFactoryTest.getFactory().getEffectiveConfigurationForResourceManager(config);
        Assert.assertFalse((boolean)effectiveConfig.contains(TaskManagerOptions.TOTAL_FLINK_MEMORY));
        Assert.assertFalse((boolean)effectiveConfig.contains(TaskManagerOptions.TOTAL_PROCESS_MEMORY));
    }

    private static ActiveResourceManagerFactory<ResourceID> getFactory() {
        return new ActiveResourceManagerFactory<ResourceID>(){

            protected ResourceManagerRuntimeServicesConfiguration createResourceManagerRuntimeServicesConfiguration(Configuration configuration) throws ConfigurationException {
                return null;
            }

            protected ResourceManagerDriver<ResourceID> createResourceManagerDriver(Configuration configuration, @Nullable String webInterfaceUrl, String rpcAddress) throws Exception {
                return null;
            }
        };
    }
}

