/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.apache.flink.runtime.net.ConnectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class ConnectionUtilsTest {
    @Test
    public void testReturnLocalHostAddressUsingHeuristics() throws Exception {
        InetSocketAddress unreachable = new InetSocketAddress("8.8.8.8", 65535);
        long start = System.nanoTime();
        InetAddress add = ConnectionUtils.findConnectingAddress((InetSocketAddress)unreachable, (long)2000L, (long)400L);
        Assert.assertTrue((System.nanoTime() - start < 30000000000L ? 1 : 0) != 0);
        Assert.assertNotNull((Object)add);
        Assert.assertEquals((Object)InetAddress.getLocalHost(), (Object)add);
    }

    @Test
    public void testFindConnectingAddressWhenGetLocalHostThrows() throws Exception {
        PowerMockito.mockStatic(InetAddress.class, (Class[])new Class[0]);
        Mockito.when((Object)InetAddress.getLocalHost()).thenThrow(new Throwable[]{new UnknownHostException()}).thenCallRealMethod();
        InetAddress loopbackAddress = Inet4Address.getByName("127.0.0.1");
        try (ServerSocket socket = new ServerSocket(0, 1, loopbackAddress);){
            InetSocketAddress socketAddress = new InetSocketAddress(loopbackAddress, socket.getLocalPort());
            InetAddress address = ConnectionUtils.findConnectingAddress((InetSocketAddress)socketAddress, (long)2000L, (long)400L);
            Assert.assertNotNull((Object)address);
        }
    }
}

