/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.utils;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.metrics.util.SystemResourcesCounter;
import org.junit.Assert;
import org.junit.Test;

public class SystemResourcesCounterTest {
    private static final double EPSILON = 0.01;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testObtainAnyMetrics() throws InterruptedException {
        SystemResourcesCounter systemResources = new SystemResourcesCounter(Time.milliseconds((long)10L));
        double initialCpuIdle = systemResources.getCpuIdle();
        systemResources.start();
        try {
            double cpuIdle;
            do {
                Thread.sleep(1L);
                cpuIdle = systemResources.getCpuIdle();
            } while (systemResources.isAlive() && (initialCpuIdle == cpuIdle || Double.isNaN(cpuIdle) || cpuIdle == 0.0));
        }
        finally {
            systemResources.shutdown();
            systemResources.join();
        }
        double totalCpuUsage = systemResources.getCpuIrq() + systemResources.getCpuNice() + systemResources.getCpuSoftIrq() + systemResources.getCpuSys() + systemResources.getCpuUser() + systemResources.getIOWait();
        Assert.assertTrue((String)"There should be at least one processor", (systemResources.getProcessorsCount() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"There should be at least one network interface", (systemResources.getNetworkInterfaceNames().length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((double)100.0, (double)(totalCpuUsage + systemResources.getCpuIdle()), (double)0.01);
    }
}

