/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TaskIOMetricGroupTest {
    @Test
    public void testTaskIOMetricGroup() throws InterruptedException {
        TaskMetricGroup task = UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
        TaskIOMetricGroup taskIO = task.getIOMetricGroup();
        Assert.assertNotNull((Object)taskIO.getNumRecordsInCounter());
        Assert.assertNotNull((Object)taskIO.getNumRecordsOutCounter());
        SimpleCounter c1 = new SimpleCounter();
        c1.inc(32L);
        SimpleCounter c2 = new SimpleCounter();
        c2.inc(64L);
        taskIO.reuseRecordsInputCounter((Counter)c1);
        taskIO.reuseRecordsOutputCounter((Counter)c2);
        Assert.assertEquals((long)32L, (long)taskIO.getNumRecordsInCounter().getCount());
        Assert.assertEquals((long)64L, (long)taskIO.getNumRecordsOutCounter().getCount());
        taskIO.getNumBytesInCounter().inc(100L);
        taskIO.getNumBytesOutCounter().inc(250L);
        taskIO.getNumBuffersOutCounter().inc(3L);
        taskIO.getIdleTimeMsPerSecond().markStart();
        taskIO.getBackPressuredTimePerSecond().markStart();
        long sleepTime = 2L;
        Thread.sleep(sleepTime);
        taskIO.getIdleTimeMsPerSecond().markEnd();
        taskIO.getBackPressuredTimePerSecond().markEnd();
        IOMetrics io = taskIO.createSnapshot();
        Assert.assertEquals((long)32L, (long)io.getNumRecordsIn());
        Assert.assertEquals((long)64L, (long)io.getNumRecordsOut());
        Assert.assertEquals((long)100L, (long)io.getNumBytesIn());
        Assert.assertEquals((long)250L, (long)io.getNumBytesOut());
        Assert.assertEquals((long)3L, (long)taskIO.getNumBuffersOutCounter().getCount());
        Assert.assertThat((Object)taskIO.getIdleTimeMsPerSecond().getCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(sleepTime)));
        Assert.assertThat((Object)taskIO.getBackPressuredTimePerSecond().getCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(sleepTime)));
    }
}

