/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class JobManagerJobGroupTest
extends TestLogger {
    @Test
    public void testGenerateScopeDefault() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerJobMetricGroup jmGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"theHostName").addJob(new JobID(), "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "jobmanager", "myJobName"}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)"theHostName.jobmanager.myJobName.name", (Object)jmGroup.getMetricIdentifier("name"));
        registry.shutdown().get();
    }

    @Test
    public void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_JM, "abc");
        cfg.setString(MetricOptions.SCOPE_NAMING_JM_JOB, "some-constant.<job_name>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobManagerJobMetricGroup jmGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"theHostName").addJob(new JobID(), "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"some-constant", "myJobName"}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)"some-constant.myJobName.name", (Object)jmGroup.getMetricIdentifier("name"));
        registry.shutdown().get();
    }

    @Test
    public void testGenerateScopeCustomWildcard() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_JM, "peter");
        cfg.setString(MetricOptions.SCOPE_NAMING_JM_JOB, "*.some-constant.<job_id>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobID jid = new JobID();
        JobManagerJobMetricGroup jmGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"theHostName").addJob(jid, "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"peter", "some-constant", jid.toString()}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)("peter.some-constant." + jid + ".name"), (Object)jmGroup.getMetricIdentifier("name"));
        registry.shutdown().get();
    }

    @Test
    public void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerJobMetricGroup jmj = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"theHostName").addJob(jid, "myJobName");
        QueryScopeInfo.JobQueryScopeInfo info = jmj.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)jid.toString(), (Object)info.jobID);
    }
}

